/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.capability.MalumPlayerDataCapability;
import com.sammy.malum.common.item.IMalumEventResponderItem;
import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.registry.common.AttributeRegistry;
import com.sammy.malum.registry.common.SoundRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.joml.Vector4f;
import team.lodestar.lodestone.helpers.ItemHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.client.LodestoneShaderRegistry;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class SoulWardHandler {
    public double soulWard;
    public double soulWardProgress;

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128347_("soulWard", this.soulWard);
        tag.m_128347_("soulWardProgress", this.soulWardProgress);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.soulWard = tag.m_128459_("soulWard");
        this.soulWardProgress = tag.m_128459_("soulWardProgress");
    }

    public static void playerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!player.m_9236_().f_46443_) {
            SoulWardHandler handler = MalumPlayerDataCapability.getCapability((Player)player).soulWardHandler;
            AttributeInstance capacity = player.m_21051_((Attribute)AttributeRegistry.SOUL_WARD_CAP.get());
            if (capacity != null) {
                if (handler.soulWard < capacity.m_22135_()) {
                    if (handler.soulWardProgress <= 0.0) {
                        handler.recoverSoulWard(player);
                    } else {
                        handler.soulWardProgress -= 1.0;
                    }
                }
                if (handler.soulWard > capacity.m_22135_()) {
                    handler.soulWard = (float)capacity.m_22135_();
                    MalumPlayerDataCapability.syncTrackingAndSelf(player);
                }
            }
        }
    }

    public static void livingHurt(LivingHurtEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        if (event.isCanceled() || event.getAmount() <= 0.0f) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            SoulWardHandler soulWardHandler = MalumPlayerDataCapability.getCapability((Player)player).soulWardHandler;
            soulWardHandler.soulWardProgress = SoulWardHandler.getSoulWardCooldown(1.0) + SoulWardHandler.getSoulWardCooldown(player);
            if (soulWardHandler.soulWard > 0.0) {
                DamageSource source = event.getSource();
                float amount = event.getAmount();
                float multiplier = source.m_269533_(LodestoneDamageTypeTags.IS_MAGIC) ? ((Double)CommonConfig.SOUL_WARD_MAGIC.getConfigValue()).floatValue() : ((Double)CommonConfig.SOUL_WARD_PHYSICAL.getConfigValue()).floatValue();
                for (ItemStack s : ItemHelper.getEventResponders((LivingEntity)player)) {
                    Item item = s.m_41720_();
                    if (!(item instanceof IMalumEventResponderItem)) continue;
                    IMalumEventResponderItem eventItem = (IMalumEventResponderItem)item;
                    multiplier = eventItem.adjustSoulWardDamageAbsorption(event, (LivingEntity)player, s, multiplier);
                    break;
                }
                float result = amount * multiplier;
                float absorbed = amount - result;
                double strength = player.m_21133_((Attribute)AttributeRegistry.SOUL_WARD_INTEGRITY.get());
                double soulwardLost = soulWardHandler.soulWard - (double)absorbed / strength;
                if (strength != 0.0) {
                    soulWardHandler.soulWard = Math.max(0.0, soulwardLost);
                } else {
                    soulwardLost = soulWardHandler.soulWard;
                    soulWardHandler.soulWard = 0.0;
                }
                for (ItemStack s : ItemHelper.getEventResponders((LivingEntity)player)) {
                    Item item = s.m_41720_();
                    if (!(item instanceof IMalumEventResponderItem)) continue;
                    IMalumEventResponderItem eventItem = (IMalumEventResponderItem)item;
                    eventItem.onSoulwardAbsorbDamage(event, player, s, soulwardLost, absorbed);
                }
                SoundEvent sound = soulWardHandler.soulWard == 0.0 ? (SoundEvent)SoundRegistry.SOUL_WARD_DEPLETE.get() : (SoundEvent)SoundRegistry.SOUL_WARD_HIT.get();
                SoundHelper.playSound((Entity)player, (SoundEvent)sound, (float)1.0f, (float)Mth.m_216267_((RandomSource)player.m_217043_(), (float)1.0f, (float)1.5f));
                event.setAmount(result);
                MalumPlayerDataCapability.syncTrackingAndSelf(player);
            }
        }
    }

    public void recoverSoulWard(Player player) {
        AttributeInstance capacity;
        this.soulWard += 1.0;
        if (!player.m_7500_() && (capacity = player.m_21051_((Attribute)AttributeRegistry.SOUL_WARD_CAP.get())) != null) {
            SoundEvent sound = this.soulWard >= capacity.m_22135_() ? (SoundEvent)SoundRegistry.SOUL_WARD_CHARGE.get() : (SoundEvent)SoundRegistry.SOUL_WARD_GROW.get();
            double pitchOffset = this.soulWard / capacity.m_22135_() * 0.5 + (double)((float)(Mth.m_14165_((double)this.soulWard) % 3) * 0.25f);
            SoundHelper.playSound((Entity)player, (SoundEvent)sound, (float)0.25f, (float)((float)(1.0 + pitchOffset)));
        }
        this.soulWardProgress += (double)SoulWardHandler.getSoulWardCooldown(player);
        MalumPlayerDataCapability.syncTrackingAndSelf(player);
    }

    public static float getSoulWardCooldown(Player player) {
        return SoulWardHandler.getSoulWardCooldown(player.m_21133_((Attribute)AttributeRegistry.SOUL_WARD_RECOVERY_RATE.get()));
    }

    public static float getSoulWardCooldown(double recoverySpeed) {
        return Mth.m_14107_((double)((double)((Integer)CommonConfig.SOUL_WARD_RATE.getConfigValue()).intValue() / recoverySpeed));
    }

    public static class ClientOnly {
        public static int fadeOut;

        public static void tick(TickEvent.ClientTickEvent event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null) {
                SoulWardHandler handler = MalumPlayerDataCapability.getCapability((Player)player).soulWardHandler;
                if (handler.soulWard >= player.m_21133_((Attribute)AttributeRegistry.SOUL_WARD_CAP.get())) {
                    if (fadeOut < 80) {
                        ++fadeOut;
                    }
                } else {
                    fadeOut = Mth.m_14045_((int)(fadeOut - 2), (int)0, (int)30);
                }
            }
        }

        public static void renderSoulWard(ForgeGui gui, GuiGraphics guiGraphics, int width, int height) {
            LocalPlayer player;
            Minecraft minecraft = Minecraft.m_91087_();
            PoseStack poseStack = guiGraphics.m_280168_();
            if (!minecraft.f_91066_.f_92062_ && gui.shouldDrawSurvivalElements() && !(player = minecraft.f_91074_).m_7500_() && !player.m_5833_()) {
                SoulWardHandler handler = MalumPlayerDataCapability.getCapability((Player)player).soulWardHandler;
                double soulWard = handler.soulWard;
                if (soulWard > 0.0) {
                    float absorb = Mth.m_14167_((float)player.m_6103_());
                    float maxHealth = (float)player.m_21051_(Attributes.f_22276_).m_22135_();
                    float armor = (float)player.m_21051_(Attributes.f_22284_).m_22135_();
                    int left = width / 2 - 91;
                    int top = height - 66;
                    if (armor == 0.0f) {
                        top += 10;
                    }
                    int healthRows = Mth.m_14167_((float)((maxHealth + absorb) / 2.0f / 10.0f));
                    int rowHeight = Math.max(10 - (healthRows - 2), 3);
                    poseStack.m_85836_();
                    gui.setupOverlayRenderState(true, false);
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)ClientOnly.getSoulWardTexture());
                    RenderSystem.depthMask((boolean)true);
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)LodestoneShaderRegistry.DISTORTED_TEXTURE.getInstance().get();
                    shaderInstance.m_173356_("YFrequency").m_5985_(15.0f);
                    shaderInstance.m_173356_("XFrequency").m_5985_(15.0f);
                    shaderInstance.m_173356_("Speed").m_5985_(550.0f);
                    shaderInstance.m_173356_("Intensity").m_5985_(120.0f);
                    VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setPosColorTexDefaultFormat().setShader(() -> shaderInstance);
                    if (fadeOut > 20) {
                        boolean isDamaged = soulWard < player.m_21133_((Attribute)AttributeRegistry.SOUL_WARD_CAP.get());
                        builder.setAlpha((float)(80 - fadeOut) / (isDamaged ? 10.0f : 60.0f));
                    }
                    int size = 13;
                    boolean forceDisplay = soulWard <= 1.0;
                    double soulWardAmount = forceDisplay ? 1.0 : Math.ceil(Math.floor(soulWard) / 3.0);
                    int i = 0;
                    while ((double)i < soulWardAmount) {
                        int row = (int)((float)i / 10.0f);
                        int x = left + i % 10 * 8;
                        int y = top - row * 4 + rowHeight * 2 - 15;
                        int progress = Math.min(3, (int)soulWard - i * 3);
                        int xTextureOffset = forceDisplay ? 31 : 1 + (3 - progress) * 15;
                        shaderInstance.m_173356_("UVCoordinates").m_142558_(new Vector4f((float)xTextureOffset / 45.0f, (float)(xTextureOffset + size) / 45.0f, 0.0f, 0.33333334f));
                        shaderInstance.m_173356_("TimeOffset").m_5985_((float)i * 150.0f);
                        builder.setPositionWithWidth((float)(x - 2), (float)(y - 2), (float)size, (float)size).setUVWithWidth((float)xTextureOffset, 0.0f, (float)size, (float)size, 45.0f).draw(poseStack);
                        if (fadeOut > 0 && fadeOut < 20) {
                            float glow = (float)(10 - Math.abs(10 - fadeOut)) / 10.0f;
                            RenderSystem.blendFunc((int)770, (int)1);
                            builder.setAlpha(glow).draw(poseStack).setAlpha(1.0f);
                            RenderSystem.defaultBlendFunc();
                        }
                        ++i;
                    }
                    shaderInstance.setUniformDefaults();
                    RenderSystem.disableBlend();
                    poseStack.m_85849_();
                }
            }
        }

        public static ResourceLocation getSoulWardTexture() {
            return MalumMod.malumPath("textures/gui/hud/soul_ward.png");
        }
    }
}

