/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.recipe;

import com.google.gson.JsonObject;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.core.handlers.SpiritHarvestHandler;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import team.lodestar.lodestone.systems.recipe.IRecipeComponent;

public class SpiritWithCount
implements IRecipeComponent {
    public final MalumSpiritType type;
    public final int count;

    public SpiritWithCount(ItemStack stack) {
        this.type = ((SpiritShardItem)stack.m_41720_()).type;
        this.count = stack.m_41613_();
    }

    public SpiritWithCount(MalumSpiritType type, int count) {
        this.type = type;
        this.count = count;
    }

    public static SpiritWithCount deserialize(JsonObject inputObject) {
        MalumSpiritType type = SpiritHarvestHandler.getSpiritType(inputObject.get("type").getAsString());
        int count = 1;
        if (inputObject.has("count")) {
            count = inputObject.get("count").getAsInt();
        }
        return new SpiritWithCount(type, count);
    }

    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", this.type.identifier);
        if (this.getCount() > 1) {
            object.addProperty("count", (Number)this.getCount());
        }
        return object;
    }

    public Component getComponent() {
        return this.type.getSpiritJarCounterComponent(this.count);
    }

    public CompoundTag save(CompoundTag tag) {
        tag.m_128359_("type", this.type.identifier);
        tag.m_128405_("count", this.count);
        return tag;
    }

    public static SpiritWithCount load(CompoundTag tag) {
        MalumSpiritType type = SpiritHarvestHandler.getSpiritType(tag.m_128461_("type"));
        int count = tag.m_128451_("count");
        return new SpiritWithCount(type, count);
    }

    public ItemStack getStack() {
        return new ItemStack((ItemLike)this.getItem(), this.getCount());
    }

    public List<ItemStack> getStacks() {
        return List.of(this.getStack());
    }

    public Item getItem() {
        return this.type.spiritShard.get();
    }

    public int getCount() {
        return this.count;
    }

    public boolean matches(ItemStack stack) {
        return stack.m_41720_().equals(this.getItem()) && stack.m_41613_() >= this.getCount();
    }
}

