/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.data.item;

import com.sammy.malum.common.item.cosmetic.weaves.AbstractWeaveItem;
import com.sammy.malum.common.item.cosmetic.weaves.PrideweaveItem;
import com.sammy.malum.common.item.curiosities.TemporarilyDisabledItem;
import com.sammy.malum.common.item.curiosities.curios.runes.AbstractRuneCurioItem;
import com.sammy.malum.common.item.curiosities.weapons.WeightOfWorldsItem;
import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.common.item.curiosities.weapons.staff.AbstractStaffItem;
import com.sammy.malum.common.item.impetus.CrackedImpetusItem;
import com.sammy.malum.common.item.impetus.ImpetusItem;
import com.sammy.malum.common.item.impetus.NodeItem;
import com.sammy.malum.common.item.spirit.SpiritShardItem;
import com.sammy.malum.data.item.MalumItemModelSmithTypes;
import com.sammy.malum.registry.common.item.ArmorSkinRegistry;
import com.sammy.malum.registry.common.item.ItemRegistry;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.SwordItem;
import net.minecraftforge.common.data.ExistingFileHelper;
import team.lodestar.lodestone.systems.datagen.ItemModelSmithTypes;
import team.lodestar.lodestone.systems.datagen.itemsmith.AbstractItemModelSmith;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneItemModelProvider;
import team.lodestar.lodestone.systems.item.ModCombatItem;

public class MalumItemModels
extends LodestoneItemModelProvider {
    public MalumItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "malum", existingFileHelper);
    }

    protected void registerModels() {
        ArmorSkinRegistry.registerItemSkins(null);
        HashSet<Supplier> items = new HashSet<Supplier>(ItemRegistry.ITEMS.getEntries());
        items.removeIf(i -> i.get() instanceof BlockItem);
        items.removeIf(i -> i.get() instanceof MalumScytheItem);
        items.removeIf(i -> i.get() instanceof WeightOfWorldsItem);
        items.removeIf(i -> i.get() instanceof TemporarilyDisabledItem);
        AbstractItemModelSmith.ItemModelSmithData data = new AbstractItemModelSmith.ItemModelSmithData((LodestoneItemModelProvider)this, items::remove);
        this.setTexturePath("cosmetic/weaves/pride/");
        ItemModelSmithTypes.GENERATED_ITEM.act(data, (Collection)items.stream().filter(i -> i.get() instanceof PrideweaveItem).collect(Collectors.toList()));
        this.setTexturePath("cosmetic/weaves/");
        ItemModelSmithTypes.GENERATED_ITEM.act(data, (Collection)items.stream().filter(i -> i.get() instanceof AbstractWeaveItem).collect(Collectors.toList()));
        this.setTexturePath("runes/");
        ItemModelSmithTypes.GENERATED_ITEM.act(data, (Collection)items.stream().filter(i -> i.get() instanceof AbstractRuneCurioItem).collect(Collectors.toList()));
        this.setTexturePath("impetus/");
        MalumItemModelSmithTypes.IMPETUS_ITEM.act(data, (Collection)items.stream().filter(i -> i.get() instanceof ImpetusItem || i.get() instanceof CrackedImpetusItem).collect(Collectors.toList()));
        ItemModelSmithTypes.GENERATED_ITEM.act(data, (Collection)items.stream().filter(i -> i.get() instanceof NodeItem).collect(Collectors.toList()));
        this.setTexturePath("");
        MalumItemModelSmithTypes.SPIRIT_ITEM.act(data, (Collection)items.stream().filter(i -> i.get() instanceof SpiritShardItem).collect(Collectors.toList()));
        ItemModelSmithTypes.HANDHELD_ITEM.act(data, (Collection)items.stream().filter(i -> i.get() instanceof DiggerItem).collect(Collectors.toList()));
        ItemModelSmithTypes.HANDHELD_ITEM.act(data, (Collection)items.stream().filter(i -> i.get() instanceof SwordItem).collect(Collectors.toList()));
        ItemModelSmithTypes.HANDHELD_ITEM.act(data, (Collection)items.stream().filter(i -> i.get() instanceof ModCombatItem).collect(Collectors.toList()));
        ItemModelSmithTypes.HANDHELD_ITEM.act(data, (Collection)items.stream().filter(i -> i.get() instanceof AbstractStaffItem).collect(Collectors.toList()));
        ItemModelSmithTypes.HANDHELD_ITEM.act(data, new Supplier[]{ItemRegistry.SOUL_STAINED_STEEL_KNIFE, ItemRegistry.TUNING_FORK, ItemRegistry.LAMPLIGHTERS_TONGS, ItemRegistry.TOTEMIC_STAFF});
        MalumItemModelSmithTypes.CATALYST_LOBBER.act(data, new Supplier[]{ItemRegistry.CATALYST_LOBBER});
        MalumItemModelSmithTypes.ARMOR_ITEM.act(data, new Supplier[]{ItemRegistry.SOUL_HUNTER_CLOAK, ItemRegistry.SOUL_HUNTER_ROBE, ItemRegistry.SOUL_HUNTER_LEGGINGS, ItemRegistry.SOUL_HUNTER_BOOTS, ItemRegistry.SOUL_STAINED_STEEL_HELMET, ItemRegistry.SOUL_STAINED_STEEL_CHESTPLATE, ItemRegistry.SOUL_STAINED_STEEL_LEGGINGS, ItemRegistry.SOUL_STAINED_STEEL_BOOTS});
        MalumItemModelSmithTypes.RITUAL_SHARD_ITEM.act(data, new Supplier[]{ItemRegistry.RITUAL_SHARD});
        ItemModelSmithTypes.GENERATED_ITEM.act(data, items);
    }

    public String m_6055_() {
        return "Malum Item Models";
    }
}

