/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.data.worldgen;

import com.sammy.malum.MalumMod;
import com.sammy.malum.registry.common.worldgen.BiomeTagRegistry;
import com.sammy.malum.registry.common.worldgen.PlacedFeatureRegistry;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeModifications {
    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        BiomeModifications.register(context, "soulstone_ore", () -> BiomeModifications.addFeatureModifier(context, BiomeModifications.getPlacedHolderSet(context, PlacedFeatureRegistry.ORE_SOULSTONE), BiomeTagRegistry.HAS_SOULSTONE, GenerationStep.Decoration.UNDERGROUND_ORES));
        BiomeModifications.register(context, "brilliant_ore", () -> BiomeModifications.addFeatureModifier(context, BiomeModifications.getPlacedHolderSet(context, PlacedFeatureRegistry.ORE_BRILLIANT), BiomeTagRegistry.HAS_BRILLIANT, GenerationStep.Decoration.UNDERGROUND_ORES));
        BiomeModifications.register(context, "natural_quartz_ore", () -> BiomeModifications.addFeatureModifier(context, BiomeModifications.getPlacedHolderSet(context, PlacedFeatureRegistry.ORE_NATURAL_QUARTZ), BiomeTagRegistry.HAS_QUARTZ, GenerationStep.Decoration.UNDERGROUND_ORES));
        BiomeModifications.register(context, "cthonic_gold_ore", () -> BiomeModifications.addFeatureModifier(context, BiomeModifications.getPlacedHolderSet(context, PlacedFeatureRegistry.ORE_CTHONIC_GOLD), BiomeTagRegistry.HAS_CTHONIC, GenerationStep.Decoration.UNDERGROUND_ORES));
        BiomeModifications.register(context, "blazing_quartz_ore", () -> BiomeModifications.addFeatureModifier(context, BiomeModifications.getPlacedHolderSet(context, PlacedFeatureRegistry.ORE_BLAZING_QUARTZ), BiomeTagRegistry.HAS_BLAZING_QUARTZ, GenerationStep.Decoration.UNDERGROUND_ORES));
        BiomeModifications.register(context, "runewood_tree", () -> BiomeModifications.addFeatureModifier(context, BiomeModifications.getPlacedHolderSet(context, PlacedFeatureRegistry.RUNEWOOD_TREE), BiomeTagRegistry.HAS_RUNEWOOD, GenerationStep.Decoration.VEGETAL_DECORATION));
        BiomeModifications.register(context, "rare_runewood_tree", () -> BiomeModifications.addFeatureModifier(context, BiomeModifications.getPlacedHolderSet(context, PlacedFeatureRegistry.RARE_RUNEWOOD_TREE), BiomeTagRegistry.HAS_RARE_RUNEWOOD, GenerationStep.Decoration.VEGETAL_DECORATION));
        BiomeModifications.register(context, "azure_runewood_tree", () -> BiomeModifications.addFeatureModifier(context, BiomeModifications.getPlacedHolderSet(context, PlacedFeatureRegistry.AZURE_RUNEWOOD_TREE), BiomeTagRegistry.HAS_AZURE_RUNEWOOD, GenerationStep.Decoration.VEGETAL_DECORATION));
        BiomeModifications.register(context, "rare_azure_runewood_tree", () -> BiomeModifications.addFeatureModifier(context, BiomeModifications.getPlacedHolderSet(context, PlacedFeatureRegistry.RARE_AZURE_RUNEWOOD_TREE), BiomeTagRegistry.HAS_RARE_AZURE_RUNEWOOD, GenerationStep.Decoration.VEGETAL_DECORATION));
        BiomeModifications.register(context, "quartz_geode", () -> BiomeModifications.addFeatureModifier(context, BiomeModifications.getPlacedHolderSet(context, PlacedFeatureRegistry.QUARTZ_GEODE_FEATURE), BiomeTagRegistry.HAS_QUARTZ, GenerationStep.Decoration.UNDERGROUND_DECORATION));
        BiomeModifications.register(context, "deepslate_quartz_geode", () -> BiomeModifications.addFeatureModifier(context, BiomeModifications.getPlacedHolderSet(context, PlacedFeatureRegistry.DEEPSLATE_QUARTZ_GEODE_FEATURE), BiomeTagRegistry.HAS_QUARTZ, GenerationStep.Decoration.UNDERGROUND_DECORATION));
    }

    public static HolderSet<PlacedFeature> getPlacedHolderSet(BootstapContext<?> context, ResourceKey<PlacedFeature> ... placedFeatures) {
        ArrayList<Holder.Reference> holders = new ArrayList<Holder.Reference>();
        for (ResourceKey<PlacedFeature> feature : placedFeatures) {
            holders.add(context.m_255420_(Registries.f_256988_).m_255043_(feature));
        }
        return HolderSet.m_205800_(holders);
    }

    private static ForgeBiomeModifiers.AddFeaturesBiomeModifier addFeatureModifier(BootstapContext<BiomeModifier> context, HolderSet<PlacedFeature> placedSet, TagKey<Biome> biomeTag, GenerationStep.Decoration decoration) {
        return new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomeTag), placedSet, decoration);
    }

    private static void register(BootstapContext<BiomeModifier> context, String name, Supplier<? extends BiomeModifier> modifier) {
        context.m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)MalumMod.malumPath(name)), (Object)modifier.get());
    }
}

