/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.data;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class PositionEffectData {
    public final double posX;
    public final double posY;
    public final double posZ;

    public PositionEffectData(FriendlyByteBuf buf) {
        this(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    public PositionEffectData(BlockPos pos) {
        this(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public PositionEffectData(Entity entity) {
        this(entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_());
    }

    public PositionEffectData(Vec3 pos) {
        this(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public PositionEffectData(double posX, double posY, double posZ) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public BlockPos getAsBlockPos() {
        return new BlockPos((int)this.posX, (int)this.posY, (int)this.posZ);
    }

    public Vec3 getAsVector() {
        return new Vec3(this.posX, this.posY, this.posZ);
    }
}

