/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.slash;

import com.sammy.malum.client.PointyDirectionalBehaviorComponent;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.visual_effects.SlashParticleEffects;
import com.sammy.malum.visual_effects.networked.ParticleEffectType;
import com.sammy.malum.visual_effects.networked.slash.SlashAttackParticleEffect;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.behaviors.components.LodestoneBehaviorComponent;

public class AscensionUppercutParticleEffect
extends SlashAttackParticleEffect {
    public AscensionUppercutParticleEffect(String id) {
        super(id);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Supplier<ParticleEffectType.ParticleEffectActor> get() {
        return () -> (level, random, positionData, colorData, nbtData) -> {
            if (!nbtData.compoundTag.m_128441_("direction")) {
                return;
            }
            CompoundTag directionData = nbtData.compoundTag.m_128469_("direction");
            double dirX = directionData.m_128459_("x");
            double dirY = directionData.m_128459_("y");
            double dirZ = directionData.m_128459_("z");
            Vec3 direction = new Vec3(dirX, dirY, dirZ);
            float yRot = (float)(Mth.m_14136_((double)direction.f_82479_, (double)direction.f_82481_) * 57.2957763671875);
            float yaw = (float)Math.toRadians(yRot);
            Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
            Vec3 up = left.m_82537_(direction);
            float angle = nbtData.compoundTag.m_128457_("angle");
            boolean mirror = nbtData.compoundTag.m_128471_("mirror");
            MalumSpiritType spirit = this.getSpiritType(nbtData);
            for (int i = 0; i < 6; ++i) {
                float upwardsOffset = (float)i * 0.4f;
                float slashOffset = 2.0f - (float)i * 0.6f;
                for (int j = 0; j < 2; ++j) {
                    float spinOffset = angle + RandomHelper.randomBetween((RandomSource)random, (float)-0.25f, (float)0.25f) + (mirror ? 3.14f : 0.0f);
                    Vec3 slashPosition = positionData.getAsVector().m_82549_(direction.m_82490_((double)slashOffset)).m_82549_(up.m_82490_((double)upwardsOffset));
                    ParticleEffectSpawner slash = SlashParticleEffects.spawnSlashParticle(level, slashPosition, spirit);
                    slash.getBuilder().setSpinData(SpinParticleData.create((float)0.0f).setSpinOffset(spinOffset).build()).setScaleData(GenericParticleData.create((float)RandomHelper.randomBetween((RandomSource)random, (float)2.5f, (float)3.0f)).build()).setMotion(direction.m_82490_((double)RandomHelper.randomBetween((RandomSource)random, (float)0.2f, (float)0.4f)).m_82520_(0.0, (double)0.8f, 0.0)).setLifetime(3 + i).setLifeDelay(i / 2).setBehavior((LodestoneBehaviorComponent)new PointyDirectionalBehaviorComponent(direction));
                    slash.spawnParticles();
                }
            }
        };
    }
}

