/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.overlay;

import com.mojang.blaze3d.platform.Window;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.theme.Theme;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.ITooltipRenderer;
import snownee.jade.impl.Tooltip;
import snownee.jade.impl.config.WailaConfig;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.overlay.RayTracing;
import snownee.jade.util.ClientProxy;

public class TooltipRenderer
implements ITooltipRenderer {
    private final Tooltip tooltip;
    private final boolean showIcon;
    private Vec2 totalSize;
    private IElement icon;
    private final int[] padding = new int[]{4, 3, 1, 4};
    private Rect2i realRect;
    private float realScale = 1.0f;

    public TooltipRenderer(Tooltip tooltip, boolean showIcon) {
        this.showIcon = showIcon;
        this.tooltip = tooltip;
        if (showIcon) {
            this.icon = RayTracing.INSTANCE.getIcon();
        }
    }

    @Override
    public int getPadding(int i) {
        return this.padding[i];
    }

    @Override
    public void setPadding(int i, int value) {
        this.padding[i] = value;
    }

    @Override
    public void recalculateSize() {
        float width = 0.0f;
        float height = 0.0f;
        for (Tooltip.Line line : this.tooltip.lines) {
            Vec2 size = line.getSize();
            width = Math.max(width, size.f_82470_);
            height += size.f_82471_;
        }
        float contentHeight = height;
        if (this.hasIcon()) {
            Vec2 size = this.icon.getCachedSize();
            this.padding[3] = (int)((float)this.padding[3] + (size.f_82470_ + 3.0f));
            height = Math.max(height, size.f_82471_);
        }
        this.totalSize = new Vec2(width += (float)(this.padding[3] + this.padding[1]), height += (float)(this.padding[0] + this.padding[2]));
        if (this.hasIcon() && this.icon.getCachedSize().f_82471_ > contentHeight) {
            this.padding[0] = (int)((float)this.padding[0] + (this.icon.getCachedSize().f_82471_ - contentHeight) / 2.0f);
        }
    }

    public void draw(GuiGraphics guiGraphics) {
        IElement icon;
        float x = this.getPadding(3);
        float y = this.getPadding(0);
        for (Tooltip.Line line : this.tooltip.lines) {
            Vec2 size = line.getSize();
            line.render(guiGraphics, x, y, this.totalSize.f_82470_ - (float)this.getPadding(1), size.f_82471_);
            y += size.f_82471_;
        }
        if (this.tooltip.sneakyDetails) {
            x = (this.totalSize.f_82470_ - (float)DisplayHelper.font().m_92895_("\u25be") + 1.0f) / 2.0f;
            float yOffset = OverlayRenderer.ticks / 5.0f % 8.0f - 2.0f;
            if (yOffset <= 4.0f) {
                y = this.totalSize.f_82471_ - 6.0f + yOffset;
                float alpha = 1.0f - Math.abs(yOffset) / 2.0f;
                int alphaChannel = (int)(255.0f * Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f));
                if (alphaChannel > 4) {
                    guiGraphics.m_280168_().m_85836_();
                    guiGraphics.m_280168_().m_252880_(x, y, 0.0f);
                    DisplayHelper.INSTANCE.drawText(guiGraphics, "\u25be", 0.0f, 0.0f, IThemeHelper.get().theme().infoColor & 0xFFFFFF | alphaChannel << 24);
                    guiGraphics.m_280168_().m_85849_();
                }
            }
        }
        if ((icon = this.getIcon()) != null) {
            Vec2 size = icon.getCachedSize();
            Vec2 offset = icon.getTranslation();
            float offsetY = offset.f_82471_;
            float min = (float)(this.getPadding(0) + this.getPadding(2)) + size.f_82471_;
            offsetY = IWailaConfig.get().getOverlay().getIconMode() == IWailaConfig.IconMode.TOP && min < this.totalSize.f_82471_ ? (offsetY += (float)this.getPadding(0)) : (offsetY += (this.totalSize.f_82471_ - size.f_82471_) / 2.0f);
            float offsetX = (float)this.getPadding(3) + offset.f_82470_ - size.f_82470_ - 3.0f;
            Tooltip.drawBorder(guiGraphics, offsetX, offsetY, icon);
            icon.render(guiGraphics, offsetX, offsetY, offsetX + size.f_82470_, offsetY + size.f_82471_);
        }
    }

    @Override
    public Tooltip getTooltip() {
        return this.tooltip;
    }

    @Override
    public boolean hasIcon() {
        return this.showIcon && Jade.CONFIG.get().getOverlay().shouldShowIcon() && this.icon != null;
    }

    @Override
    public IElement getIcon() {
        return this.hasIcon() ? this.icon : null;
    }

    @Override
    public void setIcon(IElement icon) {
        this.icon = icon;
    }

    @Override
    public Rect2i getPosition() {
        Window window = Minecraft.m_91087_().m_91268_();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        int x = (int)((float)window.m_85445_() * overlay.tryFlip(overlay.getOverlayPosX()));
        int y = (int)((float)window.m_85446_() * (1.0f - overlay.getOverlayPosY()));
        int width = (int)this.totalSize.f_82470_;
        int height = (int)this.totalSize.f_82471_;
        return new Rect2i(x, y, width, height);
    }

    @Override
    public Vec2 getSize() {
        return this.totalSize;
    }

    @Override
    public void setSize(Vec2 totalSize) {
        this.totalSize = totalSize;
    }

    @Override
    public float getRealScale() {
        return this.realScale;
    }

    @Override
    @Nullable
    public Rect2i getRealRect() {
        return this.realRect;
    }

    @Override
    public void recalculateRealRect() {
        Rect2i rect;
        Rect2i position = this.getPosition();
        WailaConfig.ConfigOverlay overlay = Jade.CONFIG.get().getOverlay();
        if (!overlay.getSquare() || IThemeHelper.get().theme().backgroundTexture != null) {
            position.m_173056_(position.m_110090_() + 2);
            position.m_173058_(position.m_110091_() + 2);
            position.m_173049_(position.m_110085_() + 1, position.m_110086_() + 1);
        }
        this.realScale = overlay.getOverlayScale();
        Window window = Minecraft.m_91087_().m_91268_();
        float thresholdHeight = (float)window.m_85446_() * overlay.getAutoScaleThreshold();
        if (this.totalSize.f_82471_ * this.realScale > thresholdHeight) {
            this.realScale = Math.max(this.realScale * 0.5f, thresholdHeight / this.totalSize.f_82471_);
        }
        position.m_173056_((int)((float)position.m_110090_() * this.realScale));
        position.m_173058_((int)((float)position.m_110091_() * this.realScale));
        position.m_173047_((int)((float)position.m_110085_() - (float)position.m_110090_() * overlay.tryFlip(overlay.getAnchorX())));
        position.m_173054_((int)((float)position.m_110086_() - (float)position.m_110091_() * overlay.getAnchorY()));
        IWailaConfig.BossBarOverlapMode mode = Jade.CONFIG.get().getGeneral().getBossBarOverlapMode();
        if (mode == IWailaConfig.BossBarOverlapMode.PUSH_DOWN && (rect = ClientProxy.getBossBarRect()) != null) {
            int tw = position.m_110090_();
            int th = position.m_110091_();
            int rw = rect.m_110090_();
            int rh = rect.m_110091_();
            int tx = position.m_110085_();
            int ty = position.m_110086_();
            int rx = rect.m_110085_();
            int ry = rect.m_110086_();
            if ((rw += rx) > tx && (rh += ry) > ty && (tw += tx) > rx && (th += ty) > ry) {
                position.m_173054_(rect.m_110091_());
            }
        }
        this.realRect = position;
    }

    public void setPaddingFromTheme(Theme theme) {
        for (int i = 0; i < 4; ++i) {
            this.setPadding(i, theme.padding[i]);
        }
        this.recalculateSize();
    }
}

