/*
 * Decompiled with CFR 0.152.
 */
package dev.imb11.fog.client.util.math;

import dev.imb11.fog.api.FogColors;
import dev.imb11.fog.client.FogManager;
import dev.imb11.fog.client.util.color.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EnvironmentCalculations {
    public static FogManager.FogSettings apply(float undergroundFactor, FogManager.FogSettings settings, float tickDelta) {
        return EnvironmentCalculations.fixElytraColor(EnvironmentCalculations.applyCaveFog(undergroundFactor, settings), tickDelta, Minecraft.m_91087_(), Minecraft.m_91087_().f_91074_, Minecraft.m_91087_().f_91073_);
    }

    private static @NotNull FogManager.FogSettings applyCaveFog(float undergroundFactor, FogManager.FogSettings settings) {
        FogColors belowGroundColors = FogColors.DEFAULT_CAVE;
        Color belowColor = belowGroundColors.getNightColor();
        float fogColorR = Mth.m_14179_((float)undergroundFactor, (float)((float)belowColor.red / 255.0f), (float)settings.fogRed());
        float fogColorG = Mth.m_14179_((float)undergroundFactor, (float)((float)belowColor.green / 255.0f), (float)settings.fogGreen());
        float fogColorB = Mth.m_14179_((float)undergroundFactor, (float)((float)belowColor.blue / 255.0f), (float)settings.fogBlue());
        return new FogManager.FogSettings(settings.fogStart(), settings.fogEnd(), fogColorR, fogColorG, fogColorB);
    }

    public static FogManager.FogSettings fixElytraColor(FogManager.FogSettings input, float tickDelta, Minecraft client, LocalPlayer player, ClientLevel world) {
        float fogColorR = input.fogRed();
        float fogColorG = input.fogGreen();
        float fogColorB = input.fogBlue();
        int surfaceTopLevel = world.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)player.m_20185_(), (int)player.m_20189_());
        int viewCutoff = surfaceTopLevel + (Integer)client.f_91066_.m_231984_().m_231551_() * 32;
        int distancePastCutoff = (int)(player.m_20186_() - (double)viewCutoff);
        if (client.f_91074_.m_20186_() > (double)viewCutoff) {
            float percentageCutoff = Mth.m_14036_((float)((float)distancePastCutoff / 25.0f), (float)0.0f, (float)1.0f);
            Vec3 skyColour = client.f_91073_.m_171660_(player.m_20182_(), tickDelta);
            fogColorR = (float)Mth.m_14139_((double)percentageCutoff, (double)fogColorR, (double)skyColour.f_82479_);
            fogColorG = (float)Mth.m_14139_((double)percentageCutoff, (double)fogColorG, (double)skyColour.f_82480_);
            fogColorB = (float)Mth.m_14139_((double)percentageCutoff, (double)fogColorB, (double)skyColour.f_82481_);
        }
        return new FogManager.FogSettings(input.fogStart(), input.fogEnd(), fogColorR, fogColorG, fogColorB);
    }
}

