/*
 * Decompiled with CFR 0.152.
 */
package com.dreu.traversableleaves.config;

import com.dreu.traversableleaves.TraversableLeaves;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.toml.TomlParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class TLConfig {
    public static boolean configNeedsRepair = false;
    static final String fileName = "config/traversable_leaves/general.toml";
    static final String DEFAULT_CONFIG_STRING = "# To reset this config to default, delete this file and rerun the game.\n# Movement Speed penalty while traversing leaves, 0 = no penalty, 99 = 99% slower (Range: 0 - 99) | Default: 50\nSpeedPenalty = 50\n\n# Whether Armor value reduces movement penalty | Default: true\nArmorHelps = true\n\n# How much armor is required to completely negate the SpeedPenalty (Range: 0 - 255) | Default: 20\nArmorCap = 20\n\n# Whether leaves behave like ladders | Default: true\nCanClimb = true\n\n# List of traversable blocks. | Default: [\"#minecraft:leaves\"]\nTraversable=[\n \"#minecraft:leaves\"\n]\n\n# Whether Entities is a \"WHITELIST\" or a \"BLACKLIST\" | Default: \"BLACKLIST\"\nEntities-Whitelist-Blacklist = \"BLACKLIST\"\n\n# List of Entities that can/cannot traverse blocks | Default: []\nEntities=[\n]\n";
    private static final Config DEFAULT_CONFIG = new TomlParser().parse("# To reset this config to default, delete this file and rerun the game.\n# Movement Speed penalty while traversing leaves, 0 = no penalty, 99 = 99% slower (Range: 0 - 99) | Default: 50\nSpeedPenalty = 50\n\n# Whether Armor value reduces movement penalty | Default: true\nArmorHelps = true\n\n# How much armor is required to completely negate the SpeedPenalty (Range: 0 - 255) | Default: 20\nArmorCap = 20\n\n# Whether leaves behave like ladders | Default: true\nCanClimb = true\n\n# List of traversable blocks. | Default: [\"#minecraft:leaves\"]\nTraversable=[\n \"#minecraft:leaves\"\n]\n\n# Whether Entities is a \"WHITELIST\" or a \"BLACKLIST\" | Default: \"BLACKLIST\"\nEntities-Whitelist-Blacklist = \"BLACKLIST\"\n\n# List of Entities that can/cannot traverse blocks | Default: []\nEntities=[\n]\n");
    private static Config CONFIG;
    public static final Set<ResourceLocation> TL_BLOCKS;
    public static final Set<ResourceLocation> TL_ENTITIES;
    private static final Set<String> BLOCKS_CACHE;
    private static final Set<String> ENTITIES_CACHE;
    public static boolean IS_ENTITIES_WHITELIST;
    private static int CACHED_SPEED_PENALTY;
    public static float MOVEMENT_MULTIPLIER;
    public static boolean CACHED_ARMOR_HELPS;
    private static int CACHED_ARMOR_CAP;
    public static float ARMOR_SCALE_FACTOR;
    public static boolean CAN_CLIMB;

    public static void repairConfig() {
        TraversableLeaves.LOGGER.info("An issue was found with config: {} | You can find a copy of faulty config at: {} | Repairing...", (Object)fileName, (Object)fileName.replace(".toml", "_faulty.toml"));
        Path sourcePath = Paths.get(fileName, new String[0]);
        Path destinationPath = Paths.get(fileName.replace(".toml", "_faulty.toml"), new String[0]);
        try {
            Files.copy(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            TraversableLeaves.LOGGER.warn("Exception during caching of faulty Traversable Leaves config | Exception: {}", (Object)e.getMessage());
        }
        try (FileWriter writer = new FileWriter(new File(fileName).getAbsolutePath());){
            StringBuilder contents = new StringBuilder().append("# To reset this config to default, delete this file and rerun the game.\n").append("# Movement Speed penalty while traversing leaves, 0 = no penalty, 99 = 99% slower (Range : 0 - 99) | Default: 50\n").append("SpeedPenalty = ").append(CACHED_SPEED_PENALTY).append("\n\n").append("# Whether Armor value reduces movement penalty | Default: true\n").append("ArmorHelps = ").append(CACHED_ARMOR_HELPS).append("\n\n").append("# How much armor is required to completely negate the SpeedPenalty (Range: 0 - 255) | Default: 20\n").append("ArmorCap = ").append(CACHED_ARMOR_CAP).append("\n\n").append("# Whether leaves behave like ladders\n").append("CanClimb = ").append(CAN_CLIMB).append("\n\n").append("# List of traversable blocks | Default: [\"#minecraft:leaves\"]\n").append("Traversable = [\n");
            for (String key : BLOCKS_CACHE) {
                contents.append("   \"").append(key).append("\",\n");
            }
            contents.append("]\n\n\n# Whether Entities is a \"WHITELIST\" or a \"BLACKLIST\" | Default: \"BLACKLIST\"\nEntities-Whitelist-Blacklist = ").append(IS_ENTITIES_WHITELIST ? "\"WHITELIST\"" : "\"BLACKLIST\"").append("\n\n#List of Entities that can/cannot traverse blocks | Default: []\n").append("Entities = [\n");
            for (String key : ENTITIES_CACHE) {
                contents.append("   \"").append(key).append("\",\n");
            }
            contents.append("]\n");
            writer.write(contents.toString());
        }
        catch (IOException e) {
            TraversableLeaves.LOGGER.warn("Exception during config repair: {}", (Object)e.getMessage());
        }
    }

    public static void parse() {
        CONFIG = TLConfig.parseConfigOrDefault();
        if (CONFIG.get("LeavesWhitelist") != null) {
            TraversableLeaves.LOGGER.info("Traversable Leaves config was outdated, your old config was stored away at: {{}} and a new template was created at: {{}}", (Object)fileName.replace(".toml", "_old.toml"), (Object)fileName);
            TLConfig.cacheAndOverwriteOldConfig();
            CONFIG = new TomlParser().parse(DEFAULT_CONFIG_STRING);
        }
    }

    private static void cacheAndOverwriteOldConfig() {
        try (FileWriter writer = new FileWriter(fileName);){
            Files.copy(Path.of(fileName, new String[0]), Path.of(fileName.replace(".toml", "_old.toml"), new String[0]), new CopyOption[0]);
            writer.write(DEFAULT_CONFIG_STRING);
        }
        catch (Exception e) {
            TraversableLeaves.LOGGER.error(e.getMessage());
        }
    }

    public static void populate() {
        ENTITIES_CACHE.clear();
        BLOCKS_CACHE.clear();
        TL_BLOCKS.clear();
        TL_ENTITIES.clear();
        CACHED_SPEED_PENALTY = TLConfig.getClampedSpeedPenalty();
        MOVEMENT_MULTIPLIER = (float)(100 - CACHED_SPEED_PENALTY) * 0.01f;
        CACHED_ARMOR_HELPS = TLConfig.getOrDefault("ArmorHelps", Boolean.class);
        CACHED_ARMOR_CAP = TLConfig.getClampedArmorCap();
        ARMOR_SCALE_FACTOR = CACHED_ARMOR_HELPS ? (1.0f - MOVEMENT_MULTIPLIER) * (1.0f / (float)CACHED_ARMOR_CAP) : 0.0f;
        IS_ENTITIES_WHITELIST = TLConfig.getWhitelistBlacklist();
        CAN_CLIMB = TLConfig.getOrDefault("CanClimb", Boolean.class);
        HashSet toRemove = new HashSet();
        TLConfig.getOrDefault("Traversable", List.class).forEach(configKey -> {
            BLOCKS_CACHE.add((String)configKey);
            if (configKey.startsWith("-")) {
                if (configKey.charAt(1) == '#') {
                    if (TLConfig.isValidBlockTag(configKey.substring(2))) {
                        for (Block block : ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation(configKey.substring(2))))) {
                            toRemove.add(ForgeRegistries.BLOCKS.getKey((Object)block));
                        }
                    }
                } else if (TLConfig.isValidBlock(configKey.substring(1))) {
                    toRemove.add(new ResourceLocation(configKey.substring(1)));
                }
            } else if (configKey.startsWith("#")) {
                if (TLConfig.isValidBlockTag(configKey.substring(1))) {
                    for (Block block : ForgeRegistries.BLOCKS.tags().getTag(BlockTags.create((ResourceLocation)new ResourceLocation(configKey.substring(1))))) {
                        TL_BLOCKS.add(ForgeRegistries.BLOCKS.getKey((Object)block));
                    }
                }
            } else if (TLConfig.isValidBlock(configKey)) {
                TL_BLOCKS.add(new ResourceLocation(configKey));
            }
        });
        TL_BLOCKS.removeAll(toRemove);
        toRemove.clear();
        TLConfig.getOrDefault("Entities", List.class).forEach(configKey -> {
            ENTITIES_CACHE.add((String)configKey);
            if (configKey.startsWith("-")) {
                if (configKey.charAt(1) == '#') {
                    if (TLConfig.isValidEntityTag(configKey.substring(2))) {
                        for (EntityType entityType : ForgeRegistries.ENTITY_TYPES.tags().getTag(TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)new ResourceLocation(configKey.substring(2))))) {
                            toRemove.add(ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType));
                        }
                    }
                } else if (TLConfig.isValidEntity(configKey.substring(1))) {
                    toRemove.add(new ResourceLocation(configKey.substring(1)));
                }
            } else if (configKey.startsWith("#")) {
                if (TLConfig.isValidEntityTag(configKey.substring(1))) {
                    for (EntityType entityType : ForgeRegistries.ENTITY_TYPES.tags().getTag(TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)new ResourceLocation(configKey.substring(1))))) {
                        TL_ENTITIES.add(ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType));
                    }
                }
            } else if (TLConfig.isValidEntity(configKey)) {
                TL_ENTITIES.add(new ResourceLocation(configKey));
            }
        });
        TL_ENTITIES.removeAll(toRemove);
        if (configNeedsRepair) {
            TLConfig.repairConfig();
        }
    }

    private static boolean getWhitelistBlacklist() {
        String whitelistBlacklist = TLConfig.getOrDefault("Entities-Whitelist-Blacklist", String.class).toUpperCase();
        if (whitelistBlacklist.equals("WHITELIST")) {
            return true;
        }
        if (whitelistBlacklist.equals("BLACKLIST")) {
            return false;
        }
        TraversableLeaves.LOGGER.warn("Invalid value for Entities-Whitelist-Blacklist in Config: {} | Expected: \"WHITELIST\" or \"BLACKLIST\", but got: \"{}\" | Using default (\"BLACKLIST\")...", (Object)fileName, (Object)whitelistBlacklist);
        return false;
    }

    private static int getClampedArmorCap() {
        int armorCap = TLConfig.getOrDefault("ArmorCap", Integer.class);
        if (armorCap < 0) {
            TraversableLeaves.LOGGER.warn("Invalid ArmorCap: '{}' in Config: {{}} | Must be greater than 0 | Setting to 0...", (Object)armorCap, (Object)fileName);
            armorCap = 0;
        } else if (armorCap > 255) {
            TraversableLeaves.LOGGER.warn("Invalid ArmorCap: '{}' in Config: {{}} | Must be less than 255 | Setting to 255...", (Object)armorCap, (Object)fileName);
            armorCap = 255;
        }
        return armorCap;
    }

    private static int getClampedSpeedPenalty() {
        int speedPenalty = TLConfig.getOrDefault("SpeedPenalty", Integer.class);
        if (speedPenalty < 0) {
            TraversableLeaves.LOGGER.warn("Invalid SpeedPenalty: '{}' in Config: {{}} | Must be greater than 0 | Setting to 0...", (Object)speedPenalty, (Object)fileName);
            speedPenalty = 0;
        } else if (speedPenalty > 99) {
            TraversableLeaves.LOGGER.warn("Invalid SpeedPenalty: '{}' in Config: {{}} | Must be less than 99 | Setting to 99...", (Object)speedPenalty, (Object)fileName);
            speedPenalty = 99;
        }
        return speedPenalty;
    }

    private static boolean isValidEntityTag(String tagId) {
        if (!ResourceLocation.m_135830_((String)tagId)) {
            TraversableLeaves.LOGGER.warn("Not a valid Entity Tag ResourceLocation: <{}> declared in Config: [{}] | Skipping Tag...", (Object)tagId, (Object)fileName);
            return false;
        }
        if (!ForgeRegistries.ENTITY_TYPES.tags().isKnownTagName(TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)new ResourceLocation(tagId)))) {
            TraversableLeaves.LOGGER.warn("Not an existing Entity Tag: <{}> declared in Config: [{}] | Skipping Tag...", (Object)tagId, (Object)fileName);
            return false;
        }
        return true;
    }

    private static boolean isValidEntity(String entityId) {
        if (!ResourceLocation.m_135830_((String)entityId)) {
            TraversableLeaves.LOGGER.warn("Not a valid Entity ResourceLocation: <{}> declared in Config: [{}] | Skipping Block...", (Object)entityId, (Object)fileName);
            return false;
        }
        if (!ModList.get().isLoaded(entityId.split(":")[0])) {
            TraversableLeaves.LOGGER.warn("Config: [{}] declared Entity: <{}> but Mod: '{{}}' is not loaded | Skipping Block...", new Object[]{fileName, entityId, entityId.split(":")[0]});
            return false;
        }
        if (!ForgeRegistries.ENTITY_TYPES.containsKey(new ResourceLocation(entityId))) {
            TraversableLeaves.LOGGER.warn("Config: [{}] declared Entity: <{}> which does not exist, check for typos! | Skipping Block...", (Object)fileName, (Object)entityId);
            return false;
        }
        return true;
    }

    private static boolean isValidBlockTag(String tagId) {
        if (!ResourceLocation.m_135830_((String)tagId)) {
            TraversableLeaves.LOGGER.warn("Not a valid Block Tag ResourceLocation: <{}> declared in Config: [{}] | Skipping Tag...", (Object)tagId, (Object)fileName);
            return false;
        }
        if (!ForgeRegistries.BLOCKS.tags().isKnownTagName(BlockTags.create((ResourceLocation)new ResourceLocation(tagId)))) {
            TraversableLeaves.LOGGER.warn("Not an existing Block Tag: <{}> declared in Config: [{}] | Skipping Tag...", (Object)tagId, (Object)fileName);
            return false;
        }
        return true;
    }

    private static boolean isValidBlock(String blockId) {
        if (!ResourceLocation.m_135830_((String)blockId)) {
            TraversableLeaves.LOGGER.warn("Not a valid Block ResourceLocation: <{}> declared in Config: [{}] | Skipping Block...", (Object)blockId, (Object)fileName);
            return false;
        }
        if (!ModList.get().isLoaded(blockId.split(":")[0])) {
            TraversableLeaves.LOGGER.warn("Config: [{}] declared Block: <{}> but Mod: '{{}}' is not loaded | Skipping Block...", new Object[]{fileName, blockId, blockId.split(":")[0]});
            return false;
        }
        if (!ForgeRegistries.BLOCKS.containsKey(new ResourceLocation(blockId))) {
            TraversableLeaves.LOGGER.warn("Config: [{}] declared Block: <{}> which does not exist, check for typos! | Skipping Block...", (Object)fileName, (Object)blockId);
            return false;
        }
        return true;
    }

    static <T> T getOrDefault(String key, Class<T> clazz) {
        try {
            if (CONFIG.get(key) == null) {
                TraversableLeaves.LOGGER.error("Key [{}] is missing from Config: [{}] | Marking config file for repair...", (Object)key, (Object)fileName);
                configNeedsRepair = true;
                return clazz.cast(DEFAULT_CONFIG.get(key));
            }
            return clazz.cast(CONFIG.get(key));
        }
        catch (Exception e) {
            TraversableLeaves.LOGGER.error("Value: [{}] for [{}] is an invalid type in Config: {} | Expected: [{}] but got: [{}] | Marking config file for repair...", new Object[]{CONFIG.get(key), key, fileName, clazz.getTypeName(), CONFIG.get(key).getClass().getTypeName()});
            configNeedsRepair = true;
            return clazz.cast(DEFAULT_CONFIG.get(key));
        }
    }

    static Config parseConfigOrDefault() {
        try {
            Files.createDirectories(Path.of("config/traversable_leaves", new String[0]), new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return new TomlParser().parse(Path.of(fileName, new String[0]).toAbsolutePath(), (path, configFormat) -> {
                FileWriter writer = new FileWriter(path.toFile().getAbsolutePath());
                writer.write(DEFAULT_CONFIG_STRING);
                writer.close();
                return true;
            });
        }
        catch (Exception e) {
            TraversableLeaves.LOGGER.error("Encountered exception during parsing of Config: {{}}, moving config to {{}} and rewriting to builtin default instead", (Object)fileName, (Object)fileName.replace(".toml", "_faulty.toml"));
            configNeedsRepair = true;
            return new TomlParser().parse(DEFAULT_CONFIG_STRING);
        }
    }

    static {
        TL_BLOCKS = new HashSet<ResourceLocation>();
        TL_ENTITIES = new HashSet<ResourceLocation>();
        BLOCKS_CACHE = new HashSet<String>();
        ENTITIES_CACHE = new HashSet<String>();
    }
}

