/*
 * Decompiled with CFR 0.152.
 */
package com.dreu.traversableleaves.mixin;

import com.dreu.traversableleaves.config.TLConfig;
import com.dreu.traversableleaves.interfaces.ITraversableBlock;
import com.dreu.traversableleaves.interfaces.ITraversableEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.ForgeHooks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ForgeHooks.class})
public class ForgeHooksMixin {
    @Redirect(method={"isLivingOnLadder"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;isLadder(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/LivingEntity;)Z"), remap=false)
    private static boolean redirectIsLadder(BlockState blockState, LevelReader level, BlockPos blockPos, LivingEntity livingEntity) {
        ITraversableBlock traversable;
        Block block;
        if (TLConfig.CAN_CLIMB && (block = blockState.m_60734_()) instanceof ITraversableBlock && (traversable = (ITraversableBlock)block).isTraversable() && livingEntity instanceof ITraversableEntity) {
            ITraversableEntity iTraversableEntity = (ITraversableEntity)livingEntity;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (iTraversableEntity.isTLJumping() && ForgeHooksMixin.shouldCollide(blockState, level, blockPos, livingEntity)) {
                    return !player.m_6047_() || player.m_7500_() && player.m_150110_().f_35935_;
                }
            } else if (ForgeHooksMixin.shouldCollide(blockState, level, blockPos, livingEntity)) {
                return ITraversableEntity.canTraverse((Entity)livingEntity);
            }
        }
        return blockState.isLadder(level, blockPos, livingEntity);
    }

    private static boolean shouldCollide(BlockState blockState, LevelReader level, BlockPos blockPos, LivingEntity livingEntity) {
        return !(livingEntity.m_20182_().f_82480_ >= blockState.m_60734_().m_5939_(blockState, (BlockGetter)level, blockPos, CollisionContext.m_82749_()).m_83297_(Direction.Axis.Y) + (double)blockPos.m_123342_());
    }
}

