/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.crafting;

import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IERecipeTypes;
import blusunrize.immersiveengineering.api.crafting.MultiblockRecipe;
import blusunrize.immersiveengineering.api.crafting.cache.CachedRecipeList;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;

public class SawmillRecipe
extends MultiblockRecipe {
    public static RegistryObject<IERecipeSerializer<SawmillRecipe>> SERIALIZER;
    public static final CachedRecipeList<SawmillRecipe> RECIPES;
    public final Ingredient input;
    public final Lazy<ItemStack> stripped;
    public final NonNullList<Lazy<ItemStack>> secondaryStripping = NonNullList.m_122779_();
    public final Lazy<ItemStack> output;
    public final NonNullList<Lazy<ItemStack>> secondaryOutputs = NonNullList.m_122779_();

    public SawmillRecipe(ResourceLocation id, Lazy<ItemStack> output, Lazy<ItemStack> stripped, Ingredient input, int energy) {
        super(output, IERecipeTypes.SAWMILL, id);
        this.output = output;
        this.stripped = stripped;
        this.input = input;
        this.setTimeAndEnergy(80, energy);
        this.setInputList(Lists.newArrayList((Object[])new Ingredient[]{this.input}));
        this.outputList = Lazy.of(() -> NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])new ItemStack[]{(ItemStack)this.output.get()}));
    }

    protected IERecipeSerializer<SawmillRecipe> getIESerializer() {
        return (IERecipeSerializer)SERIALIZER.get();
    }

    @Override
    public NonNullList<ItemStack> getActualItemOutputs() {
        NonNullList list = NonNullList.m_122779_();
        list.add((Object)((ItemStack)this.stripped.get()));
        for (Lazy output : this.secondaryStripping) {
            if (((ItemStack)output.get()).m_41619_()) continue;
            list.add((Object)((ItemStack)output.get()));
        }
        list.add((Object)((ItemStack)this.output.get()));
        for (Lazy output : this.secondaryOutputs) {
            if (((ItemStack)output.get()).m_41619_()) continue;
            list.add((Object)((ItemStack)output.get()));
        }
        return list;
    }

    public SawmillRecipe addToSecondaryStripping(Lazy<ItemStack> output) {
        Preconditions.checkNotNull(output);
        this.secondaryStripping.add(output);
        return this;
    }

    public SawmillRecipe addToSecondaryOutput(Lazy<ItemStack> output) {
        Preconditions.checkNotNull(output);
        this.secondaryOutputs.add(output);
        return this;
    }

    public static SawmillRecipe findRecipe(Level level, ItemStack input) {
        if (!input.m_41619_()) {
            for (SawmillRecipe recipe : RECIPES.getRecipes(level)) {
                if (!recipe.input.test(input)) continue;
                return recipe;
            }
        }
        return null;
    }

    @Override
    public int getMultipleProcessTicks() {
        return 0;
    }

    static {
        RECIPES = new CachedRecipeList<SawmillRecipe>(IERecipeTypes.SAWMILL);
    }
}

