/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.utils.CapabilityReference;
import blusunrize.immersiveengineering.api.utils.DirectionalBlockPos;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.redstone.CapabilityRedstoneNetwork;
import blusunrize.immersiveengineering.api.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.wires.redstone.RedstoneNetworkHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConnectorBundledBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IBlockBounds,
IRedstoneConnector {
    public static final List<IBundledProvider> EXTRA_SOURCES = new ArrayList<IBundledProvider>();
    private final CapabilityReference<CapabilityRedstoneNetwork.RedstoneBundleConnection> attached = CapabilityReference.forBlockEntityAt(this, this::getAttachedFace, CapabilityRedstoneNetwork.REDSTONE_BUNDLE_CONNECTION);
    private boolean dirtyExtraSource = false;

    public ConnectorBundledBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends ConnectorBundledBlockEntity>)((BlockEntityType)IEBlockEntities.CONNECTOR_BUNDLED.get()), pos, state);
    }

    public ConnectorBundledBlockEntity(BlockEntityType<? extends ConnectorBundledBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    private DirectionalBlockPos getAttachedFace() {
        return new DirectionalBlockPos(this.f_58858_.m_121945_(this.getFacing()), this.getFacing().m_122424_());
    }

    @Override
    public void tickServer() {
        CapabilityRedstoneNetwork.RedstoneBundleConnection connection = this.attached.getNullable();
        if (connection != null && connection.pollDirty() || this.dirtyExtraSource) {
            this.getHandler().updateValues();
            this.dirtyExtraSource = false;
        }
    }

    public byte getValue(int redstoneChannel) {
        return this.getHandler().getValue(redstoneChannel);
    }

    private RedstoneNetworkHandler getHandler() {
        return Objects.requireNonNull(this.globalNet.getLocalNet(this.f_58858_).getHandler(RedstoneNetworkHandler.ID, RedstoneNetworkHandler.class));
    }

    @Override
    public void onChange(ConnectionPoint cp, RedstoneNetworkHandler handler) {
        if (!this.f_58857_.f_46443_) {
            CapabilityRedstoneNetwork.RedstoneBundleConnection connection = this.attached.getNullable();
            if (connection != null) {
                connection.onChange(handler.getValuesExcluding(cp), this.getFacing().m_122424_());
            }
            BlockState stateHere = this.f_58857_.m_8055_(this.f_58858_);
            this.markContainingBlockForUpdate(stateHere);
            this.markBlockForUpdate(this.f_58858_.m_121945_(this.getFacing()), this.f_58857_.m_8055_(this.f_58858_.m_121945_(this.getFacing())));
        }
    }

    @Override
    public void updateInput(byte[] signals, ConnectionPoint cp) {
        CapabilityRedstoneNetwork.RedstoneBundleConnection connection = this.attached.getNullable();
        if (connection != null) {
            connection.updateInput(signals, this.getFacing().m_122424_());
        }
        DirectionalBlockPos attachedTo = this.getAttachedFace();
        for (IBundledProvider source : EXTRA_SOURCES) {
            byte[] provided = source.getEmittedState(this.f_58857_, attachedTo.position(), attachedTo.side());
            if (provided == null) continue;
            for (int color = 0; color < 16; ++color) {
                signals[color] = (byte)Math.max(signals[color], provided[color]);
            }
        }
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        return "REDSTONE".equals(cableType.getCategory());
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return ConnectorBlock.DEFAULT_FACING_PROP;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        Direction side = this.getFacing().m_122424_();
        double conRadius = type.getRenderDiameter() / 2.0;
        return new Vec3(0.5 - conRadius * (double)side.m_122429_(), 0.5 - conRadius * (double)side.m_122430_(), 0.5 - conRadius * (double)side.m_122431_());
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return EnergyConnectorBlockEntity.getConnectorBounds(this.getFacing(), 0.625f);
    }

    @Override
    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)RedstoneNetworkHandler.ID);
    }

    @Override
    protected void onNeighborBlockChange(BlockPos otherPos) {
        IBundledProvider source;
        super.onNeighborBlockChange(otherPos);
        DirectionalBlockPos attachedTo = this.getAttachedFace();
        if (!otherPos.equals((Object)attachedTo.position()) || this.attached.isPresent()) {
            return;
        }
        byte[] overrideState = null;
        Iterator<IBundledProvider> iterator = EXTRA_SOURCES.iterator();
        while (iterator.hasNext() && (overrideState = (source = iterator.next()).getEmittedState(this.f_58857_, attachedTo.position(), attachedTo.side())) == null) {
        }
        RedstoneNetworkHandler handler = this.getHandler();
        for (int color = 0; color < 16 && !this.dirtyExtraSource; ++color) {
            byte current = handler.getValue(color);
            this.dirtyExtraSource = overrideState != null ? current == overrideState[color] : current != 0;
        }
    }

    @Override
    public void setRemovedIE() {
        super.setRemovedIE();
        CapabilityRedstoneNetwork.RedstoneBundleConnection connection = this.attached.getNullable();
        if (connection != null) {
            connection.onChange(new byte[16], this.getFacing().m_122424_());
        }
    }

    public static interface IBundledProvider {
        @Nullable
        public byte[] getEmittedState(Level var1, BlockPos var2, Direction var3);
    }
}

