/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.loot;

import blusunrize.immersiveengineering.common.util.loot.IELootFunctions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import javax.annotation.Nonnull;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class PropertyCountLootFunction
extends LootItemConditionalFunction {
    private final String propertyName;

    protected PropertyCountLootFunction(LootItemCondition[] conditionsIn, String propertyName) {
        super(conditionsIn);
        this.propertyName = propertyName;
    }

    @Nonnull
    protected ItemStack m_7372_(@Nonnull ItemStack stack, @Nonnull LootContext context) {
        BlockState blockstate = (BlockState)context.m_78953_(LootContextParams.f_81461_);
        if (blockstate != null) {
            stack.m_41764_(this.getPropertyValue(blockstate));
        }
        return stack;
    }

    private int getPropertyValue(BlockState blockState) {
        for (Property prop : blockState.m_61147_()) {
            if (!(prop instanceof IntegerProperty) || !prop.m_61708_().equals(this.propertyName)) continue;
            return (Integer)blockState.m_61143_((Property)((IntegerProperty)prop));
        }
        return 1;
    }

    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)IELootFunctions.PROPERTY_COUNT.get();
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        private final String propertyName;

        public Builder(String propertyName) {
            this.propertyName = propertyName;
        }

        @Nonnull
        protected Builder getThis() {
            return this;
        }

        @Nonnull
        public LootItemFunction m_7453_() {
            return new PropertyCountLootFunction(this.m_80699_(), this.propertyName);
        }
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<PropertyCountLootFunction> {
        private static final String JSON_KEY = "propery_name";

        public void serialize(JsonObject object, PropertyCountLootFunction function, JsonSerializationContext context) {
            super.m_6170_(object, (LootItemConditionalFunction)function, context);
            object.addProperty(JSON_KEY, function.propertyName);
        }

        @Nonnull
        public PropertyCountLootFunction deserialize(@Nonnull JsonObject object, @Nonnull JsonDeserializationContext deserializationContext, @Nonnull LootItemCondition[] conditionsIn) {
            return new PropertyCountLootFunction(conditionsIn, GsonHelper.m_13906_((JsonObject)object, (String)JSON_KEY));
        }
    }
}

