/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.spline;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import mcjty.lib.spline.Spline;

public class BSpline<T>
extends Spline<T> {
    private int idx;
    private float t;

    public BSpline(Supplier<T> supplier, BiFunction<T, T, T> subtract, BiFunction<T, T, T> add, BiFunction<T, Float, T> scale) {
        super(supplier, subtract, add, scale);
    }

    protected float baseFunction(int i, float t) {
        return switch (i) {
            case -2 -> (((-t + 3.0f) * t - 3.0f) * t + 1.0f) / 6.0f;
            case -1 -> ((3.0f * t - 6.0f) * t * t + 4.0f) / 6.0f;
            case 0 -> (((-3.0f * t + 3.0f) * t + 3.0f) * t + 1.0f) / 6.0f;
            case 1 -> t * t * t / 6.0f;
            default -> 0.0f;
        };
    }

    @Override
    public void calculate(float time) {
        this.idx = 0;
        while (this.idx < this.points.size() - 1) {
            if (time >= ((Float)this.times.get(this.idx)).floatValue() && time <= ((Float)this.times.get(this.idx + 1)).floatValue()) {
                this.t = 1.0f - (((Float)this.times.get(this.idx + 1)).floatValue() - time) / (((Float)this.times.get(this.idx + 1)).floatValue() - ((Float)this.times.get(this.idx)).floatValue());
                return;
            }
            ++this.idx;
        }
        this.t = 1.0f;
    }

    @Override
    public T getInterpolated() {
        Object val = this.supplier.get();
        for (int j = -2; j <= 1; ++j) {
            int id = this.idx + j + 1;
            Object pp = id == -1 ? this.subtract.apply(this.points.get(0), this.subtract.apply(this.points.get(1), this.points.get(0))) : (id == -2 ? this.subtract.apply(this.points.get(0), this.scale.apply(this.subtract.apply(this.points.get(1), this.points.get(0)), Float.valueOf(2.0f))) : (id >= this.points.size() ? this.subtract.apply(this.points.get(this.points.size() - 1), this.subtract.apply(this.points.get(this.points.size() - 2), this.points.get(this.points.size() - 1))) : this.points.get(id)));
            float base = this.baseFunction(j, this.t);
            val = this.add.apply(val, this.scale.apply(pp, Float.valueOf(base)));
        }
        return val;
    }
}

