/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.client.render.entity.model;

import com.faboslav.friendsandfoes.common.client.render.entity.model.BaseEntityModel;
import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public final class WildfireEntityModel<T extends WildfireEntity>
extends BaseEntityModel<T> {
    private static final String MODEL_PART_HEAD = "head";
    private static final String MODEL_PART_HELMET = "helmet";
    private static final String MODEL_PART_BODY = "body";
    private static final String MODEL_PART_FRONT_SHIELD = "frontShield";
    private static final String MODEL_PART_RIGHT_SHIELD = "rightShield";
    private static final String MODEL_PART_BACK_SHIELD = "BackShield";
    private static final String MODEL_PART_LEFT_SHIELD = "LeftShield";
    private final ModelPart head;
    private final ModelPart helmet;
    private final ModelPart body;
    private final ModelPart frontShield;
    private final ModelPart rightShield;
    private final ModelPart backShield;
    private final ModelPart leftShield;
    private final ModelPart[] shields;

    public WildfireEntityModel(ModelPart root) {
        super(root);
        this.head = this.root.m_171324_(MODEL_PART_HEAD);
        this.helmet = this.head.m_171324_(MODEL_PART_HELMET);
        this.body = this.root.m_171324_(MODEL_PART_BODY);
        this.frontShield = this.root.m_171324_(MODEL_PART_FRONT_SHIELD);
        this.rightShield = this.root.m_171324_(MODEL_PART_RIGHT_SHIELD);
        this.backShield = this.root.m_171324_(MODEL_PART_BACK_SHIELD);
        this.leftShield = this.root.m_171324_(MODEL_PART_LEFT_SHIELD);
        this.shields = new ModelPart[]{this.frontShield, this.rightShield, this.backShield, this.leftShield};
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition root = modelData.m_171576_();
        root.m_171599_(MODEL_PART_HEAD, CubeListBuilder.m_171558_().m_171514_(0, 26).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition head = root.m_171597_(MODEL_PART_HEAD);
        head.m_171599_(MODEL_PART_HELMET, CubeListBuilder.m_171558_().m_171514_(0, 43).m_171488_(-4.0f, -9.0f, -4.0f, 8.0f, 9.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        root.m_171599_(MODEL_PART_BODY, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 21.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        root.m_171599_(MODEL_PART_FRONT_SHIELD, CubeListBuilder.m_171558_().m_171514_(17, 0).m_171488_(-5.0f, 1.0f, -10.0f, 10.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        root.m_171599_(MODEL_PART_RIGHT_SHIELD, CubeListBuilder.m_171558_().m_171514_(17, 0).m_171488_(-5.0f, 1.0f, -10.0f, 10.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.2618f, (float)-1.5708f, (float)0.0f));
        root.m_171599_(MODEL_PART_BACK_SHIELD, CubeListBuilder.m_171558_().m_171514_(17, 0).m_171488_(-5.0f, 1.0f, -10.0f, 10.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.2618f, (float)3.1416f, (float)0.0f));
        root.m_171599_(MODEL_PART_LEFT_SHIELD, CubeListBuilder.m_171558_().m_171514_(17, 0).m_171488_(-5.0f, 1.0f, -10.0f, 10.0f, 17.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)3.0f, (float)0.0f, (float)-0.2618f, (float)1.5708f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    public void setAngles(T wildfire, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        int activeShieldsCount = ((WildfireEntity)((Object)wildfire)).getActiveShieldsCount();
        float rotationSpeedMultiplier = Math.max(1, 4 - activeShieldsCount);
        float baseRotationUnit = (float)Math.PI * 2 / (float)activeShieldsCount;
        float bodyCounterRotation = 0.0f;
        float additionalShieldRotation = animationProgress * 0.1f * rotationSpeedMultiplier % ((float)Math.PI * 2);
        for (int i = 0; i < 4; ++i) {
            if (i > activeShieldsCount) {
                this.shields[i].f_233556_ = true;
                continue;
            }
            this.shields[i].f_233556_ = false;
            this.shields[i].f_104204_ = bodyCounterRotation + baseRotationUnit * (float)i + additionalShieldRotation;
        }
        this.head.f_104204_ = headYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }
}

