/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.forge;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class ReplaceRopeByConfigModifier
extends LootModifier {
    public static final Supplier<Codec<ReplaceRopeByConfigModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> ReplaceRopeByConfigModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, ReplaceRopeByConfigModifier::new)));

    protected ReplaceRopeByConfigModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        CommonConfigs.ReplaceTableMode ropeConfig = CommonConfigs.Functional.ROPE_REPLACE_LOOT_TABLES.get();
        if (ropeConfig == CommonConfigs.ReplaceTableMode.NONE) {
            return generatedLoot;
        }
        for (int i = 0; i < generatedLoot.size(); ++i) {
            ItemStack stack = (ItemStack)generatedLoot.get(i);
            if (!stack.m_204117_(ModTags.ROPES) || stack.m_150930_(ModRegistry.ROPE_ITEM.get())) continue;
            if (ropeConfig == CommonConfigs.ReplaceTableMode.REPLACE) {
                generatedLoot.set(i, (Object)new ItemStack((ItemLike)ModRegistry.ROPE_ITEM.get(), stack.m_41613_()));
                continue;
            }
            if (ropeConfig != CommonConfigs.ReplaceTableMode.REMOVE) continue;
            generatedLoot.add((Object)ItemStack.f_41583_);
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

