/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.renderers.entities.vehicles;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import earth.terrarium.adastra.client.models.entities.vehicles.RocketModel;
import earth.terrarium.adastra.common.entities.vehicles.Rocket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class RocketRenderer
extends EntityRenderer<Rocket> {
    public static final ResourceLocation TIER_1_TEXTURE = new ResourceLocation("ad_astra", "textures/entity/rocket/tier_1_rocket.png");
    public static final ResourceLocation TIER_2_TEXTURE = new ResourceLocation("ad_astra", "textures/entity/rocket/tier_2_rocket.png");
    public static final ResourceLocation TIER_3_TEXTURE = new ResourceLocation("ad_astra", "textures/entity/rocket/tier_3_rocket.png");
    public static final ResourceLocation TIER_4_TEXTURE = new ResourceLocation("ad_astra", "textures/entity/rocket/tier_4_rocket.png");
    protected final EntityModel<Rocket> model;
    private final ResourceLocation texture;

    public RocketRenderer(EntityRendererProvider.Context context, ModelLayerLocation layer, ResourceLocation texture) {
        super(context);
        this.f_114477_ = 0.5f;
        this.model = new RocketModel<Rocket>(context.m_174023_(layer));
        this.texture = texture;
    }

    public void render(Rocket entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, buffer, packedLight);
        try (CloseablePoseStack pose = new CloseablePoseStack(poseStack);){
            if (!Minecraft.m_91087_().m_91104_() && (entity.isLaunching() || entity.hasLaunched())) {
                entityYaw += (float)(entity.m_9236_().f_46441_.m_188583_() * 0.3);
            }
            pose.m_252880_(0.0f, 1.55f, 0.0f);
            pose.m_252781_(Axis.f_252436_.m_252977_(180.0f - entityYaw));
            float xRot = Mth.m_14179_((float)partialTick, (float)entity.f_19860_, (float)entity.m_146909_());
            pose.m_252781_(Axis.f_252403_.m_252977_(-xRot));
            pose.m_85841_(-1.0f, -1.0f, 1.0f);
            this.model.m_6973_((Entity)entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            VertexConsumer consumer = buffer.m_6299_(this.model.m_103119_(this.getTextureLocation(entity)));
            this.model.m_7695_((PoseStack)pose, consumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public ResourceLocation getTextureLocation(Rocket entity) {
        return this.texture;
    }

    public static class ItemRenderer
    extends BlockEntityWithoutLevelRenderer {
        private final ModelLayerLocation layer;
        private final ResourceLocation texture;
        private EntityModel<?> model;

        public ItemRenderer(ModelLayerLocation layer, ResourceLocation texture) {
            super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
            this.layer = layer;
            this.texture = texture;
        }

        public void m_108829_(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
            if (this.model == null) {
                this.model = new RocketModel(Minecraft.m_91087_().m_167973_().m_171103_(this.layer));
            }
            VertexConsumer consumer = buffer.m_6299_(RenderType.m_110464_((ResourceLocation)this.texture));
            try (CloseablePoseStack pose = new CloseablePoseStack(poseStack);){
                pose.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                pose.m_85837_(0.0, -1.501, 0.0);
                this.model.m_7695_((PoseStack)pose, consumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

