/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blocks.pipes;

import earth.terrarium.adastra.common.blockentities.pipes.PipeBlockEntity;
import earth.terrarium.adastra.common.blocks.base.BasicEntityBlock;
import earth.terrarium.adastra.common.blocks.base.Wrenchable;
import earth.terrarium.adastra.common.blocks.pipes.TransferablePipe;
import earth.terrarium.adastra.common.blocks.properties.PipeProperty;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.registry.ModSoundEvents;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PipeBlock
extends BasicEntityBlock
implements SimpleWaterloggedBlock,
Wrenchable,
TransferablePipe {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<PipeProperty> CONNECTED_UP = EnumProperty.m_61587_((String)"connected_up", PipeProperty.class);
    public static final EnumProperty<PipeProperty> CONNECTED_DOWN = EnumProperty.m_61587_((String)"connected_down", PipeProperty.class);
    public static final EnumProperty<PipeProperty> CONNECTED_NORTH = EnumProperty.m_61587_((String)"connected_north", PipeProperty.class);
    public static final EnumProperty<PipeProperty> CONNECTED_EAST = EnumProperty.m_61587_((String)"connected_east", PipeProperty.class);
    public static final EnumProperty<PipeProperty> CONNECTED_SOUTH = EnumProperty.m_61587_((String)"connected_south", PipeProperty.class);
    public static final EnumProperty<PipeProperty> CONNECTED_WEST = EnumProperty.m_61587_((String)"connected_west", PipeProperty.class);
    public static final EnumMap<Direction, EnumProperty<PipeProperty>> DIRECTION_TO_CONNECTION = (EnumMap)Util.m_137469_(new EnumMap(Direction.class), map -> {
        map.put(Direction.UP, CONNECTED_UP);
        map.put(Direction.DOWN, CONNECTED_DOWN);
        map.put(Direction.NORTH, CONNECTED_NORTH);
        map.put(Direction.EAST, CONNECTED_EAST);
        map.put(Direction.SOUTH, CONNECTED_SOUTH);
        map.put(Direction.WEST, CONNECTED_WEST);
    });
    private final Map<BlockState, VoxelShape> shapes = new HashMap<BlockState, VoxelShape>();
    private final long transferRate;
    private final TransferablePipe.Type type;

    public PipeBlock(long transferRate, TransferablePipe.Type type, double size, BlockBehaviour.Properties properties) {
        super(properties, true);
        this.transferRate = transferRate;
        this.type = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(CONNECTED_UP, (Comparable)((Object)PipeProperty.NONE))).m_61124_(CONNECTED_DOWN, (Comparable)((Object)PipeProperty.NONE))).m_61124_(CONNECTED_NORTH, (Comparable)((Object)PipeProperty.NONE))).m_61124_(CONNECTED_EAST, (Comparable)((Object)PipeProperty.NONE))).m_61124_(CONNECTED_SOUTH, (Comparable)((Object)PipeProperty.NONE))).m_61124_(CONNECTED_WEST, (Comparable)((Object)PipeProperty.NONE)));
        if (size > 0.0) {
            this.f_49792_.m_61056_().forEach(state -> this.shapes.put((BlockState)state, PipeBlock.makeShape(state, size)));
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, CONNECTED_UP, CONNECTED_DOWN, CONNECTED_NORTH, CONNECTED_EAST, CONNECTED_SOUTH, CONNECTED_WEST});
    }

    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (this.type == TransferablePipe.Type.ENERGY) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.ad_astra.energy_transfer_tick", (Object[])new Object[]{this.transferRate}).m_130940_(ChatFormatting.GOLD));
            TooltipUtils.addDescriptionComponent(tooltip, ConstantComponents.CABLE_INFO);
        } else {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.ad_astra.fluid_transfer_tick", (Object[])new Object[]{FluidConstants.toMillibuckets((long)this.transferRate)}).m_130940_(ChatFormatting.GOLD));
            TooltipUtils.addDescriptionComponent(tooltip, ConstantComponents.FLUID_PIPE_INFO);
        }
    }

    @Override
    public long transferRate() {
        return this.transferRate;
    }

    @Override
    public TransferablePipe.Type type() {
        return this.type;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapes.getOrDefault(state, Shapes.m_83144_());
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidState = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_().equals(Fluids.f_76193_)));
    }

    public static Optional<Direction> getDirectionByVec(Vec3 hit, BlockPos pos) {
        Vec3 relativePos = hit.m_82520_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_()));
        if (relativePos.f_82479_ < 0.125) {
            return Optional.of(Direction.WEST);
        }
        if (relativePos.f_82479_ > 0.875) {
            return Optional.of(Direction.EAST);
        }
        if (relativePos.f_82481_ < 0.125) {
            return Optional.of(Direction.NORTH);
        }
        if (relativePos.f_82481_ > 0.875) {
            return Optional.of(Direction.SOUTH);
        }
        if (relativePos.f_82480_ < 0.125) {
            return Optional.of(Direction.DOWN);
        }
        if (relativePos.f_82480_ > 0.875) {
            return Optional.of(Direction.UP);
        }
        return Optional.empty();
    }

    @Override
    public void onWrench(Level level, BlockPos pos, BlockState state, Direction side, Player user, Vec3 hitPos) {
        if (!level.m_5776_()) {
            EnumProperty<PipeProperty> property = DIRECTION_TO_CONNECTION.get(PipeBlock.getDirectionByVec(hitPos, pos).orElse(user.m_6144_() ? side.m_122424_() : side));
            level.m_46597_(pos, (BlockState)state.m_61122_(property));
            level.m_5594_(null, pos, (SoundEvent)ModSoundEvents.WRENCH.get(), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.2f + 0.9f);
            user.m_5661_(switch ((PipeProperty)((Object)level.m_8055_(pos).m_61143_(property))) {
                default -> throw new IncompatibleClassChangeError();
                case PipeProperty.NONE -> ConstantComponents.PIPE_NONE;
                case PipeProperty.NORMAL -> ConstantComponents.PIPE_NORMAL;
                case PipeProperty.INSERT -> ConstantComponents.PIPE_INSERT;
                case PipeProperty.EXTRACT -> ConstantComponents.PIPE_EXTRACT;
            }, true);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        this.update(level, pos);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        this.update((Level)level, pos, state, direction);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)blockEntity;
            pipe.pipeChanged((Level)level, pos);
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    private void update(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return;
        }
        for (Direction direction : Direction.values()) {
            this.update(level, pos, level.m_8055_(pos), direction);
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PipeBlockEntity) {
            PipeBlockEntity pipe = (PipeBlockEntity)blockEntity;
            pipe.pipeChanged(level, pos);
        }
    }

    private void update(Level level, BlockPos pos, BlockState state, Direction direction) {
        if (level.m_5776_()) {
            return;
        }
        EnumProperty<PipeProperty> directionProperty = DIRECTION_TO_CONNECTION.get(direction);
        boolean canConnect = this.canConnect(level, pos, direction);
        PipeProperty pipe = (PipeProperty)((Object)state.m_61143_(directionProperty));
        if ((pipe.isInsert() || pipe.isExtract()) && canConnect) {
            return;
        }
        level.m_46597_(pos, (BlockState)state.m_61124_(directionProperty, (Comparable)((Object)(canConnect ? PipeProperty.NORMAL : PipeProperty.NONE))));
    }

    private boolean canConnect(Level level, BlockPos pos, Direction direction) {
        BlockPos connectPos = pos.m_121945_(direction);
        BlockState connectState = level.m_8055_(connectPos);
        Block block = connectState.m_60734_();
        if (block instanceof TransferablePipe) {
            TransferablePipe pipe = (TransferablePipe)block;
            return pipe.type() == this.type;
        }
        BlockEntity entity = level.m_7702_(connectPos);
        if (entity == null) {
            return false;
        }
        if (this.type == TransferablePipe.Type.ENERGY) {
            return EnergyContainer.holdsEnergy((BlockEntity)entity, (Direction)direction.m_122424_());
        }
        if (this.type == TransferablePipe.Type.FLUID) {
            return FluidContainer.holdsFluid((BlockEntity)entity, (Direction)direction.m_122424_());
        }
        return false;
    }

    public static Direction[] getConnectedDirections(BlockState state) {
        return (Direction[])DIRECTION_TO_CONNECTION.entrySet().stream().filter(entry -> !((PipeProperty)((Object)((Object)state.m_61143_((Property)entry.getValue())))).isNone()).map(Map.Entry::getKey).toArray(Direction[]::new);
    }

    public static VoxelShape makeShape(BlockState state, double size) {
        VoxelShape shape = Shapes.m_83048_((double)size, (double)size, (double)size, (double)(1.0 - size), (double)(1.0 - size), (double)(1.0 - size));
        if (!((PipeProperty)((Object)state.m_61143_(CONNECTED_UP))).isNone()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)size, (double)size, (double)size, (double)(1.0 - size), (double)1.0, (double)(1.0 - size)));
        }
        if (!((PipeProperty)((Object)state.m_61143_(CONNECTED_DOWN))).isNone()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)size, (double)0.0, (double)size, (double)(1.0 - size), (double)(1.0 - size), (double)(1.0 - size)));
        }
        if (!((PipeProperty)((Object)state.m_61143_(CONNECTED_NORTH))).isNone()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)size, (double)size, (double)0.0, (double)(1.0 - size), (double)(1.0 - size), (double)(1.0 - size)));
        }
        if (!((PipeProperty)((Object)state.m_61143_(CONNECTED_EAST))).isNone()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)size, (double)size, (double)size, (double)1.0, (double)(1.0 - size), (double)(1.0 - size)));
        }
        if (!((PipeProperty)((Object)state.m_61143_(CONNECTED_SOUTH))).isNone()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)size, (double)size, (double)size, (double)(1.0 - size), (double)(1.0 - size), (double)1.0));
        }
        if (!((PipeProperty)((Object)state.m_61143_(CONNECTED_WEST))).isNone()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)size, (double)size, (double)(1.0 - size), (double)(1.0 - size), (double)(1.0 - size)));
        }
        return shape;
    }
}

