/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.smokestack.block.be;

import com.railwayteam.railways.content.smokestack.ISpeedNotifiable;
import com.railwayteam.railways.content.smokestack.block.SmokeStackBlock;
import com.simibubi.create.content.contraptions.ContraptionWorld;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import java.util.List;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class DieselSmokeStackBlockEntity
extends SmartBlockEntity
implements ISpeedNotifiable {
    private LerpedFloat rpmLimiter;
    private double fanRotation;
    private double lastRotateTime;
    private double notifiedSpeed;

    public DieselSmokeStackBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public double getRpm(float partialTicks) {
        boolean enabled = (Boolean)this.m_58900_().m_61143_((Property)SmokeStackBlock.ENABLED);
        if (this.rpmLimiter == null) {
            this.rpmLimiter = LerpedFloat.linear().startWithValue(enabled ? 1.0 : 0.0);
        }
        this.rpmLimiter.chase(enabled ? 1.0 : 0.0, 0.05, LerpedFloat.Chaser.EXP);
        double speed = 32.0;
        if (this.f_58857_ instanceof ContraptionWorld || this.f_58857_ instanceof VirtualRenderWorld) {
            speed = this.notifiedSpeed;
        }
        return speed * (double)this.rpmLimiter.getValue(partialTicks);
    }

    public void tick() {
        super.tick();
        if (this.rpmLimiter != null) {
            this.rpmLimiter.tickChaser();
        }
    }

    public double getFanRotation(double rpm) {
        double currentTime = this.f_58857_ == null ? 0.0 : (double)AnimationTickHolder.getRenderTime((LevelAccessor)this.f_58857_);
        double delta = currentTime - this.lastRotateTime;
        this.lastRotateTime += delta;
        double movementAmt = delta / 20.0 / 60.0 * rpm * 360.0;
        this.fanRotation += movementAmt;
        while (this.fanRotation > 360.0) {
            this.fanRotation -= 360.0;
        }
        while (this.fanRotation < 0.0) {
            this.fanRotation += 360.0;
        }
        return this.fanRotation;
    }

    @Override
    public void notifySpeed(double speed) {
        this.notifiedSpeed = 112.0 / (1.0 + Math.pow(2.0, -16.0 * speed + 10.0)) + 48.0;
    }
}

