/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.handlers;

import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributeRegistry;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;

public class LodestoneAttributeEventHandler {
    public static void processAttributes(LivingHurtEvent event) {
        Entity entity;
        AttributeInstance magicResistance;
        if (event.isCanceled() || event.getAmount() <= 0.0f) {
            return;
        }
        DamageSource source = event.getSource();
        LivingEntity target = event.getEntity();
        float amount = event.getAmount();
        Holder damageType = source.m_269150_();
        if (damageType.m_203656_(LodestoneDamageTypeTags.IS_MAGIC) && (magicResistance = target.m_21051_((Attribute)LodestoneAttributeRegistry.MAGIC_RESISTANCE.get())) != null) {
            amount /= (float)Math.max(magicResistance.m_22135_(), (double)0.01f);
        }
        if ((entity = source.m_7639_()) instanceof LivingEntity) {
            AttributeInstance magicDamage;
            LivingEntity attacker = (LivingEntity)entity;
            if (damageType.m_203656_(LodestoneDamageTypeTags.IS_MAGIC)) {
                AttributeInstance magicProficiency = attacker.m_21051_((Attribute)LodestoneAttributeRegistry.MAGIC_PROFICIENCY.get());
                if (magicProficiency != null) {
                    amount *= (float)magicProficiency.m_22135_();
                }
                event.setAmount(amount);
            } else if (damageType.m_203656_(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC) && (magicDamage = attacker.m_21051_((Attribute)LodestoneAttributeRegistry.MAGIC_DAMAGE.get())) != null && magicDamage.m_22135_() > 0.0 && !target.m_21224_()) {
                float magicDamageAmount = (float)magicDamage.m_22135_();
                if (attacker instanceof Player) {
                    Player player = (Player)attacker;
                    if (damageType.m_203656_(LodestoneDamageTypeTags.IGNORES_MAGIC_ATTACK_COOLDOWN_SCALAR)) {
                        magicDamageAmount *= player.m_36403_(0.0f);
                    }
                }
                DamageSource magic = DamageTypeHelper.create((ResourceKey<DamageType>)DamageTypes.f_268515_, (Entity)attacker);
                target.f_19802_ = 0;
                target.m_6469_(magic, magicDamageAmount);
            }
        }
    }
}

