/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.chassis;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.contraption.transformable.TransformableBlock;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.contraptions.chassis.ChassisBlockEntity;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public abstract class AbstractChassisBlock
extends RotatedPillarBlock
implements IWrenchable,
IBE<ChassisBlockEntity>,
TransformableBlock {
    public AbstractChassisBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!player.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(handIn);
        boolean isSlimeBall = heldItem.m_204117_(Tags.Items.SLIMEBALLS) || AllItems.SUPER_GLUE.isIn(heldItem);
        BooleanProperty affectedSide = this.getGlueableSide(state, hit.m_82434_());
        if (affectedSide == null) {
            return InteractionResult.PASS;
        }
        if (isSlimeBall && ((Boolean)state.m_61143_((Property)affectedSide)).booleanValue()) {
            for (Direction face : Iterate.directions) {
                BooleanProperty glueableSide = this.getGlueableSide(state, face);
                if (glueableSide == null || ((Boolean)state.m_61143_((Property)glueableSide)).booleanValue() || !this.glueAllowedOnSide((BlockGetter)worldIn, pos, state, face)) continue;
                if (worldIn.f_46443_) {
                    Vec3 vec = hit.m_82450_();
                    worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123753_, vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0);
                    return InteractionResult.SUCCESS;
                }
                AllSoundEvents.SLIME_ADDED.playOnServer(worldIn, (Vec3i)pos, 0.5f, 1.0f);
                state = (BlockState)state.m_61124_((Property)glueableSide, (Comparable)Boolean.valueOf(true));
            }
            if (!worldIn.f_46443_) {
                worldIn.m_46597_(pos, state);
            }
            return InteractionResult.SUCCESS;
        }
        if (!(heldItem.m_41619_() && player.m_6144_() || isSlimeBall)) {
            return InteractionResult.PASS;
        }
        if ((Boolean)state.m_61143_((Property)affectedSide) == isSlimeBall) {
            return InteractionResult.PASS;
        }
        if (!this.glueAllowedOnSide((BlockGetter)worldIn, pos, state, hit.m_82434_())) {
            return InteractionResult.PASS;
        }
        if (worldIn.f_46443_) {
            Vec3 vec = hit.m_82450_();
            worldIn.m_7106_((ParticleOptions)ParticleTypes.f_123753_, vec.f_82479_, vec.f_82480_, vec.f_82481_, 0.0, 0.0, 0.0);
            return InteractionResult.SUCCESS;
        }
        AllSoundEvents.SLIME_ADDED.playOnServer(worldIn, (Vec3i)pos, 0.5f, 1.0f);
        worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)affectedSide, (Comparable)Boolean.valueOf(isSlimeBall)));
        return InteractionResult.SUCCESS;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        BooleanProperty glueableSide;
        if (rotation == Rotation.NONE) {
            return state;
        }
        BlockState rotated = super.m_6843_(state, rotation);
        for (Direction face : Iterate.directions) {
            glueableSide = this.getGlueableSide(rotated, face);
            if (glueableSide == null) continue;
            rotated = (BlockState)rotated.m_61124_((Property)glueableSide, (Comparable)Boolean.valueOf(false));
        }
        for (Direction face : Iterate.directions) {
            Direction rotatedFacing;
            BooleanProperty rotatedGlueableSide;
            glueableSide = this.getGlueableSide(state, face);
            if (glueableSide == null || !((Boolean)state.m_61143_((Property)glueableSide)).booleanValue() || (rotatedGlueableSide = this.getGlueableSide(rotated, rotatedFacing = rotation.m_55954_(face))) == null) continue;
            rotated = (BlockState)rotated.m_61124_((Property)rotatedGlueableSide, (Comparable)Boolean.valueOf(true));
        }
        return rotated;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        BooleanProperty glueableSide;
        if (mirrorIn == Mirror.NONE) {
            return state;
        }
        BlockState mirrored = state;
        for (Direction face : Iterate.directions) {
            glueableSide = this.getGlueableSide(mirrored, face);
            if (glueableSide == null) continue;
            mirrored = (BlockState)mirrored.m_61124_((Property)glueableSide, (Comparable)Boolean.valueOf(false));
        }
        for (Direction face : Iterate.directions) {
            Direction mirroredFacing;
            BooleanProperty mirroredGlueableSide;
            glueableSide = this.getGlueableSide(state, face);
            if (glueableSide == null || !((Boolean)state.m_61143_((Property)glueableSide)).booleanValue() || (mirroredGlueableSide = this.getGlueableSide(mirrored, mirroredFacing = mirrorIn.m_54848_(face))) == null) continue;
            mirrored = (BlockState)mirrored.m_61124_((Property)mirroredGlueableSide, (Comparable)Boolean.valueOf(true));
        }
        return mirrored;
    }

    @Override
    public BlockState transform(BlockState state, StructureTransform transform) {
        if (transform.mirror != null) {
            state = this.m_6943_(state, transform.mirror);
        }
        if (transform.rotationAxis == Direction.Axis.Y) {
            return this.m_6843_(state, transform.rotation);
        }
        return this.transformInner(state, transform);
    }

    protected BlockState transformInner(BlockState state, StructureTransform transform) {
        BooleanProperty glueableSide;
        if (transform.rotation == Rotation.NONE) {
            return state;
        }
        BlockState rotated = (BlockState)state.m_61124_((Property)f_55923_, (Comparable)transform.rotateAxis((Direction.Axis)state.m_61143_((Property)f_55923_)));
        AbstractChassisBlock block = (AbstractChassisBlock)state.m_60734_();
        for (Direction face : Iterate.directions) {
            glueableSide = block.getGlueableSide(rotated, face);
            if (glueableSide == null) continue;
            rotated = (BlockState)rotated.m_61124_((Property)glueableSide, (Comparable)Boolean.valueOf(false));
        }
        for (Direction face : Iterate.directions) {
            Direction rotatedFacing;
            BooleanProperty rotatedGlueableSide;
            glueableSide = block.getGlueableSide(state, face);
            if (glueableSide == null || !((Boolean)state.m_61143_((Property)glueableSide)).booleanValue() || (rotatedGlueableSide = block.getGlueableSide(rotated, rotatedFacing = transform.rotateFacing(face))) == null) continue;
            rotated = (BlockState)rotated.m_61124_((Property)rotatedGlueableSide, (Comparable)Boolean.valueOf(true));
        }
        return rotated;
    }

    public abstract BooleanProperty getGlueableSide(BlockState var1, Direction var2);

    protected boolean glueAllowedOnSide(BlockGetter world, BlockPos pos, BlockState state, Direction side) {
        return true;
    }

    @Override
    public Class<ChassisBlockEntity> getBlockEntityClass() {
        return ChassisBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends ChassisBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.CHASSIS.get();
    }
}

