/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.cannon_control.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import rbasamoyai.createbigcannons.cannon_control.cannon_types.CannonContraptionTypeRegistry;
import rbasamoyai.createbigcannons.cannon_control.cannon_types.ICannonContraptionType;
import rbasamoyai.createbigcannons.cannon_control.config.CannonMountBlockPropertiesProvider;
import rbasamoyai.createbigcannons.cannon_control.config.CannonMountBlockPropertiesSerializer;
import rbasamoyai.createbigcannons.cannon_control.config.CannonMountEntityPropertiesProvider;
import rbasamoyai.createbigcannons.cannon_control.config.CannonMountEntityPropertiesSerializer;
import rbasamoyai.createbigcannons.multiloader.NetworkPlatform;
import rbasamoyai.createbigcannons.network.RootPacket;
import rbasamoyai.createbigcannons.utils.CBCRegistryUtils;
import rbasamoyai.createbigcannons.utils.CBCUtils;

public class CannonMountPropertiesHandler {
    private static final Map<BlockEntityType<?>, Map<ICannonContraptionType, CannonMountBlockPropertiesProvider>> BLOCK_MOUNT_PROPERTIES = new Reference2ObjectOpenHashMap();
    private static final Map<EntityType<?>, Map<ICannonContraptionType, CannonMountEntityPropertiesProvider>> ENTITY_MOUNT_PROPERTIES = new Reference2ObjectOpenHashMap();
    private static final Map<BlockEntityType<?>, CannonMountBlockPropertiesSerializer<?>> BLOCK_MOUNT_SERIALIZERS = new Reference2ReferenceOpenHashMap();
    private static final Map<EntityType<?>, CannonMountEntityPropertiesSerializer> ENTITY_MOUNT_SERIALIZERS = new Reference2ReferenceOpenHashMap();
    private static final CannonMountBlockPropertiesProvider FALLBACK_BLOCK = new CannonMountBlockPropertiesProvider(){

        @Override
        public float maximumElevation(Level level, BlockState state, BlockPos pos) {
            return 0.0f;
        }

        @Override
        public float maximumDepression(Level level, BlockState state, BlockPos pos) {
            return 0.0f;
        }
    };
    private static final CannonMountEntityPropertiesProvider FALLBACK_ENTITY = new CannonMountEntityPropertiesProvider(){

        @Override
        public float maximumElevation(Entity entity) {
            return 0.0f;
        }

        @Override
        public float maximumDepression(Entity entity) {
            return 0.0f;
        }
    };

    public static <T extends CannonMountBlockPropertiesSerializer<?>> T registerBlockMountSerializer(BlockEntityType<?> type, T ser) {
        if (BLOCK_MOUNT_SERIALIZERS.containsKey(type)) {
            throw new IllegalStateException("Serializer for block entity " + String.valueOf(CBCRegistryUtils.getBlockEntityTypeLocation(type)) + " already registered");
        }
        BLOCK_MOUNT_SERIALIZERS.put(type, ser);
        return ser;
    }

    public static <T extends CannonMountEntityPropertiesSerializer> T registerEntityMountSerializer(EntityType<?> type, T ser) {
        if (ENTITY_MOUNT_SERIALIZERS.containsKey(type)) {
            throw new IllegalStateException("Serializer for block entity " + String.valueOf(CBCRegistryUtils.getEntityTypeLocation(type)) + " already registered");
        }
        ENTITY_MOUNT_SERIALIZERS.put(type, ser);
        return ser;
    }

    public static CannonMountBlockPropertiesProvider getProperties(BlockEntity be, ICannonContraptionType contraptionType) {
        return CannonMountPropertiesHandler.getProperties(be.m_58903_(), contraptionType);
    }

    public static CannonMountBlockPropertiesProvider getProperties(BlockEntityType<?> beType, ICannonContraptionType contraptionType) {
        return BLOCK_MOUNT_PROPERTIES.containsKey(beType) ? BLOCK_MOUNT_PROPERTIES.get(beType).getOrDefault(contraptionType, FALLBACK_BLOCK) : FALLBACK_BLOCK;
    }

    public static CannonMountEntityPropertiesProvider getProperties(Entity entity, ICannonContraptionType contraptionType) {
        return CannonMountPropertiesHandler.getProperties(entity.m_6095_(), contraptionType);
    }

    public static CannonMountEntityPropertiesProvider getProperties(EntityType<?> entityType, ICannonContraptionType contraptionType) {
        return ENTITY_MOUNT_PROPERTIES.containsKey(entityType) ? ENTITY_MOUNT_PROPERTIES.get(entityType).getOrDefault(contraptionType, FALLBACK_ENTITY) : FALLBACK_ENTITY;
    }

    public static void writeBuf(FriendlyByteBuf buf) {
        Map<ICannonContraptionType, Object> map;
        buf.m_130130_(BLOCK_MOUNT_PROPERTIES.size());
        for (Map.Entry<BlockEntityType<?>, Map<ICannonContraptionType, CannonMountBlockPropertiesProvider>> entry : BLOCK_MOUNT_PROPERTIES.entrySet()) {
            buf.m_130085_(CBCRegistryUtils.getBlockEntityTypeLocation(entry.getKey()));
            map = entry.getValue();
            buf.m_130130_(map.size());
            for (Map.Entry<ICannonContraptionType, CannonMountBlockPropertiesProvider> entry2 : map.entrySet()) {
                buf.m_130085_(CannonContraptionTypeRegistry.getKey(entry2.getKey()));
                CannonMountPropertiesHandler.toNetworkCasted(buf, entry.getKey(), entry2.getValue());
            }
        }
        buf.m_130130_(ENTITY_MOUNT_PROPERTIES.size());
        for (Map.Entry<Object, Map<ICannonContraptionType, Object>> entry : ENTITY_MOUNT_PROPERTIES.entrySet()) {
            buf.m_130085_(CBCRegistryUtils.getEntityTypeLocation((EntityType)entry.getKey()));
            map = entry.getValue();
            buf.m_130130_(map.size());
            for (Map.Entry<ICannonContraptionType, Object> entry3 : map.entrySet()) {
                buf.m_130085_(CannonContraptionTypeRegistry.getKey(entry3.getKey()));
                CannonMountPropertiesHandler.toNetworkCasted(buf, (EntityType)entry.getKey(), (CannonMountEntityPropertiesProvider)entry3.getValue());
            }
        }
    }

    private static <T extends CannonMountBlockPropertiesProvider> void toNetworkCasted(FriendlyByteBuf buf, BlockEntityType<?> beType, T properties) {
        CannonMountBlockPropertiesSerializer<?> ser = BLOCK_MOUNT_SERIALIZERS.get(beType);
        ser.toNetwork(properties, buf);
    }

    private static <T extends CannonMountEntityPropertiesProvider> void toNetworkCasted(FriendlyByteBuf buf, EntityType<?> entityType, T properties) {
        CannonMountEntityPropertiesSerializer ser = ENTITY_MOUNT_SERIALIZERS.get(entityType);
        ser.toNetwork(properties, buf);
    }

    public static void readBuf(FriendlyByteBuf buf) {
        BLOCK_MOUNT_PROPERTIES.clear();
        int blockSz = buf.m_130242_();
        for (int i = 0; i < blockSz; ++i) {
            ResourceLocation beTypeLoc = buf.m_130281_();
            BlockEntityType<?> beType = CBCRegistryUtils.getBlockEntityType(beTypeLoc);
            CannonMountBlockPropertiesSerializer<?> ser = BLOCK_MOUNT_SERIALIZERS.get(beType);
            int mapSz = buf.m_130242_();
            Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
            for (int j = 0; j < mapSz; ++j) {
                ResourceLocation contraptionTypeLoc = buf.m_130281_();
                ICannonContraptionType contraptionType = CannonContraptionTypeRegistry.get(contraptionTypeLoc);
                map.put(contraptionType, ser.fromNetwork(buf));
            }
            BLOCK_MOUNT_PROPERTIES.put(beType, (Map<ICannonContraptionType, CannonMountBlockPropertiesProvider>)map);
        }
        ENTITY_MOUNT_PROPERTIES.clear();
        int entitySz = buf.m_130242_();
        for (int i = 0; i < entitySz; ++i) {
            ResourceLocation entityTypeLoc = buf.m_130281_();
            EntityType<?> entityType = CBCRegistryUtils.getEntityType(entityTypeLoc);
            CannonMountEntityPropertiesSerializer ser = ENTITY_MOUNT_SERIALIZERS.get(entityType);
            int mapSz = buf.m_130242_();
            Reference2ObjectOpenHashMap map = new Reference2ObjectOpenHashMap();
            for (int j = 0; j < mapSz; ++j) {
                ResourceLocation contraptionTypeLoc = buf.m_130281_();
                ICannonContraptionType contraptionType = CannonContraptionTypeRegistry.get(contraptionTypeLoc);
                map.put(contraptionType, ser.fromNetwork(buf));
            }
            ENTITY_MOUNT_PROPERTIES.put(entityType, (Map<ICannonContraptionType, CannonMountEntityPropertiesProvider>)map);
        }
    }

    public static void syncTo(ServerPlayer player) {
        NetworkPlatform.sendToClientPlayer(new ClientboundSyncCannonMountPropertiesPacket(), player);
    }

    public static void syncToAll(MinecraftServer server) {
        NetworkPlatform.sendToClientAll(new ClientboundSyncCannonMountPropertiesPacket(), server);
    }

    public record ClientboundSyncCannonMountPropertiesPacket(@Nullable FriendlyByteBuf buf) implements RootPacket
    {
        public ClientboundSyncCannonMountPropertiesPacket() {
            this(null);
        }

        public static ClientboundSyncCannonMountPropertiesPacket copyOf(FriendlyByteBuf buf) {
            return new ClientboundSyncCannonMountPropertiesPacket(new FriendlyByteBuf(buf.copy()));
        }

        @Override
        public void rootEncode(FriendlyByteBuf buf) {
            CannonMountPropertiesHandler.writeBuf(buf);
        }

        @Override
        public void handle(Executor exec, PacketListener listener, @Nullable ServerPlayer sender) {
            if (this.buf != null) {
                CannonMountPropertiesHandler.readBuf(this.buf);
            }
        }
    }

    public static class EntityReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final EntityReloadListener INSTANCE = new EntityReloadListener();

        public EntityReloadListener() {
            super(GSON, "cannon_mounts/entities");
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiler) {
            ENTITY_MOUNT_PROPERTIES.clear();
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                JsonElement el = entry.getValue();
                if (!el.isJsonObject()) continue;
                try {
                    ResourceLocation loc = entry.getKey();
                    String[] pathComponents = loc.m_135815_().split("/");
                    ResourceLocation entityLoc = CBCUtils.location(loc.m_135827_(), pathComponents[0]);
                    ResourceLocation cannonTypeLoc = CBCUtils.location(pathComponents[1], pathComponents[2]);
                    EntityType<?> entityType = CBCRegistryUtils.getOptionalEntityType(entityLoc).orElseThrow(() -> new JsonSyntaxException("Unknown entity type '" + String.valueOf(entityLoc) + "'"));
                    ICannonContraptionType contraptionType = CannonContraptionTypeRegistry.getOptional(cannonTypeLoc).orElseThrow(() -> new JsonSyntaxException("Unknown cannon contraption type '" + String.valueOf(cannonTypeLoc) + "'"));
                    if (!ENTITY_MOUNT_SERIALIZERS.containsKey(entityType)) continue;
                    CannonMountEntityPropertiesSerializer ser = ENTITY_MOUNT_SERIALIZERS.get(entityType);
                    if (!ENTITY_MOUNT_PROPERTIES.containsKey(entityType)) {
                        ENTITY_MOUNT_PROPERTIES.put(entityType, (Map<ICannonContraptionType, CannonMountEntityPropertiesProvider>)new Reference2ObjectOpenHashMap());
                    }
                    Map<ICannonContraptionType, CannonMountEntityPropertiesProvider> mountMap = ENTITY_MOUNT_PROPERTIES.get(entityType);
                    mountMap.put(contraptionType, (CannonMountEntityPropertiesProvider)ser.fromJson(entityType, contraptionType, el.getAsJsonObject()));
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class BlockEntityReloadListener
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new Gson();
        public static final BlockEntityReloadListener INSTANCE = new BlockEntityReloadListener();

        public BlockEntityReloadListener() {
            super(GSON, "cannon_mounts/block_entities");
        }

        protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiler) {
            BLOCK_MOUNT_PROPERTIES.clear();
            for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
                JsonElement el = entry.getValue();
                if (!el.isJsonObject()) continue;
                try {
                    ResourceLocation loc = entry.getKey();
                    String[] pathComponents = loc.m_135815_().split("/");
                    ResourceLocation blockEntityLoc = CBCUtils.location(loc.m_135827_(), pathComponents[0]);
                    ResourceLocation cannonTypeLoc = CBCUtils.location(pathComponents[1], pathComponents[2]);
                    BlockEntityType<?> beType = CBCRegistryUtils.getOptionalBlockEntityType(blockEntityLoc).orElseThrow(() -> new JsonSyntaxException("Unknown block entity type '" + String.valueOf(blockEntityLoc) + "'"));
                    ICannonContraptionType contraptionType = CannonContraptionTypeRegistry.getOptional(cannonTypeLoc).orElseThrow(() -> new JsonSyntaxException("Unknown cannon contraption type '" + String.valueOf(cannonTypeLoc) + "'"));
                    if (!BLOCK_MOUNT_SERIALIZERS.containsKey(beType)) continue;
                    CannonMountBlockPropertiesSerializer<?> ser = BLOCK_MOUNT_SERIALIZERS.get(beType);
                    if (!BLOCK_MOUNT_PROPERTIES.containsKey(beType)) {
                        BLOCK_MOUNT_PROPERTIES.put(beType, (Map<ICannonContraptionType, CannonMountBlockPropertiesProvider>)new Reference2ObjectOpenHashMap());
                    }
                    Map<ICannonContraptionType, CannonMountBlockPropertiesProvider> mountMap = BLOCK_MOUNT_PROPERTIES.get(beType);
                    mountMap.put(contraptionType, (CannonMountBlockPropertiesProvider)ser.fromJson(beType, contraptionType, el.getAsJsonObject()));
                }
                catch (Exception exception) {}
            }
        }
    }
}

