/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.lyivx.ls_furniture.common.blocks.entity.MailboxBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.FastColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class MailboxRenderer
implements BlockEntityRenderer<MailboxBlockEntity> {
    private final BlockEntityRendererProvider.Context context;
    private static final float[] sideRotationY2D = new float[]{0.0f, 0.0f, 2.0f, 0.0f, 3.0f, 1.0f};
    private static final int TEXT_COLOR_TRANSPARENT = FastColor.ARGB32.m_13660_((int)0, (int)255, (int)255, (int)255);

    public MailboxRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    private float getRotationYForSide2D(Direction side) {
        return sideRotationY2D[side.ordinal()] * 90.0f * (float)Math.PI / 180.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(MailboxBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Level level = blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        String ownerDisplayName = blockEntity.getOwnerDisplayName() != null ? blockEntity.getOwnerDisplayName().getString() : "";
        float distance = (float)Math.sqrt(blockEntity.m_58899_().m_203193_((Position)player.m_20182_()));
        float alpha = Math.max(1.0f - distance / 10.0f, 0.05f);
        if (distance > 10.0f) {
            return;
        }
        float Line1Offset = -0.0625f;
        BlockState blockState = blockEntity.m_58900_();
        Direction side = (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        poseStack.m_85836_();
        try {
            switch (side) {
                case NORTH: {
                    poseStack.m_252880_(0.5f, 0.775f, 0.6545f);
                    break;
                }
                case SOUTH: {
                    poseStack.m_252880_(0.5f, 0.775f, 0.3455f);
                    break;
                }
                case WEST: {
                    poseStack.m_252880_(0.6545f, 0.775f, 0.5f);
                    break;
                }
                case EAST: {
                    poseStack.m_252880_(0.3455f, 0.775f, 0.5f);
                }
            }
            poseStack.m_252931_(new Matrix4f().rotateYXZ(this.getRotationYForSide2D(side), 0.0f, 0.0f));
            poseStack.m_252880_(-0.5f, 0.0f, -0.5f);
            float zOffset = 0.940625f;
            packedLight = 255;
            this.renderLine(ownerDisplayName, Line1Offset, zOffset, packedLight, poseStack, buffer, alpha);
        }
        finally {
            poseStack.m_85849_();
        }
    }

    private void renderLine(String text, float yOffset, float zOffset, int packedLight, PoseStack poseStack, MultiBufferSource buffer, float alpha) {
        Font textRenderer = this.context.m_173586_();
        int textWidth = textRenderer.m_92895_(text);
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, yOffset, zOffset);
        poseStack.m_85841_(0.0052083335f, -0.0052083335f, 1.0f);
        int color = 0xFFFFFF;
        color = (int)(255.0f * alpha) << 24 | TEXT_COLOR_TRANSPARENT;
        float x = (float)(-textWidth) / 2.0f;
        float y = 0.0f;
        boolean dropShadow = false;
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        Font.DisplayMode displayMode = Font.DisplayMode.NORMAL;
        int backgroundColor = 0;
        textRenderer.m_271703_(text, x, y, color, dropShadow, matrix, buffer, displayMode, backgroundColor, packedLight);
        poseStack.m_85849_();
    }
}

