/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.lyivx.ls_furniture.common.blocks.entity.TombstoneBlockEntity;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class TombstoneRenderer
implements BlockEntityRenderer<TombstoneBlockEntity> {
    private final Font font;
    private static final float[] sideRotationY2D = new float[]{0.0f, 0.0f, 2.0f, 0.0f, 3.0f, 1.0f};

    public TombstoneRenderer(BlockEntityRendererProvider.Context context) {
        this.font = context.m_173586_();
    }

    private float getRotationYForSide2D(Direction side) {
        return sideRotationY2D[side.ordinal()] * 90.0f * (float)Math.PI / 180.0f;
    }

    public void render(TombstoneBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        String[] lines = blockEntity.getLines();
        float[] textSizes = blockEntity.getTextSizes();
        DyeColor color = blockEntity.getColor();
        boolean isGlowing = blockEntity.isGlowing();
        poseStack.m_85836_();
        BlockState blockState = blockEntity.m_58900_();
        Direction side = (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        switch (side) {
            case NORTH: {
                poseStack.m_85837_(0.5, (double)0.63f, 0.749375);
                break;
            }
            case SOUTH: {
                poseStack.m_85837_(0.5, (double)0.63f, 0.250625);
                break;
            }
            case WEST: {
                poseStack.m_85837_(0.749375, (double)0.63f, 0.5);
                break;
            }
            case EAST: {
                poseStack.m_85837_(0.250625, (double)0.63f, 0.5);
            }
        }
        poseStack.m_252931_(new Matrix4f().rotateY(this.getRotationYForSide2D(side)));
        float baseScale = 0.01f;
        poseStack.m_85841_(baseScale, -baseScale, baseScale);
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        int textColor = color.m_41071_() | 0xFF000000;
        int packedLightForText = isGlowing ? 0xF000F0 : packedLight;
        int a = color.m_41071_() >> 24 & 0xFF;
        int r = (int)((float)(color.m_41071_() >> 16 & 0xFF) * 0.4f);
        int g = (int)((float)(color.m_41071_() >> 8 & 0xFF) * 0.4f);
        int b = (int)((float)(color.m_41071_() & 0xFF) * 0.4f);
        int outlineColor = color == DyeColor.BLACK ? -988212 : a << 24 | r << 16 | g << 8 | b;
        float lineHeight = 20.0f;
        float totalHeight = lineHeight * (float)(lines.length - 1);
        float startY = -totalHeight / 2.0f;
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (line == null || line.isEmpty()) continue;
            float lineScale = textSizes[i];
            float y = startY + (float)i * lineHeight;
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, y, 0.0f);
            poseStack.m_85841_(lineScale, lineScale, 1.0f);
            float x = (float)(-this.font.m_92895_(line)) / 2.0f;
            if (isGlowing) {
                this.renderOutline(line, x, 0.0f, outlineColor, poseStack.m_85850_().m_252922_(), buffer, packedLightForText);
            }
            this.font.m_271703_(line, x, 0.0f, textColor, false, poseStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.POLYGON_OFFSET, 0, packedLightForText);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    private void renderOutline(String text, float x, float y, int color, Matrix4f matrix, MultiBufferSource buffer, int packedLight) {
        for (int xOffset = -1; xOffset <= 1; ++xOffset) {
            for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                if (xOffset == 0 && yOffset == 0) continue;
                this.font.m_271703_(text, x + (float)xOffset * 0.5f, y + (float)yOffset * 0.5f, color, false, matrix, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
            }
        }
    }
}

