/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.client.screens.widgets;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.lyivx.ls_furniture.client.screens.WorkstationScreen;
import net.lyivx.ls_furniture.client.screens.widgets.FakeLevel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;

public class RenderWindowWidget
extends AbstractWidget {
    private final Supplier<FakeLevel> fakeLevelSupplier;
    private final Consumer<BlockState> onStateChange;
    private BlockState currentState;
    private boolean isDragging = false;
    private boolean isDraggingStarted = false;
    private int lastMouseX;
    private int lastMouseY;
    private float rotationX = 0.0f;
    private float rotationY = 0.0f;
    private long mouseDownTime;
    private static final long CLICK_TIME_THRESHOLD = 100L;
    private float scale = 20.0f;
    private static final float MIN_SCALE = 5.0f;
    private static final float MAX_SCALE = 40.0f;
    private static final float SCROLL_SENSITIVITY = 0.5f;
    private boolean isRightDragging = false;
    private double translateX = 0.0;
    private double translateY = 0.0;
    private static final double TRANSLATION_SENSITIVITY = 0.01;

    public RenderWindowWidget(int x, int y, int width, int height, Supplier<FakeLevel> fakeLevelSupplier, Consumer<BlockState> onStateChange) {
        super(x, y, width, height, CommonComponents.f_237098_);
        this.fakeLevelSupplier = fakeLevelSupplier;
        this.onStateChange = onStateChange;
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        FakeLevel fakeLevel = this.fakeLevelSupplier.get();
        if (fakeLevel == null) {
            return;
        }
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        Window window = Minecraft.m_91087_().m_91268_();
        double guiScale = window.m_85449_();
        int scissorX = (int)((double)(this.m_252754_() + 1) * guiScale);
        int scissorY = (int)((double)window.m_85442_() - (double)(this.m_252907_() - 1 + this.m_93694_()) * guiScale);
        int scissorWidth = (int)((double)(this.m_5711_() - 2) * guiScale);
        int scissorHeight = (int)((double)(this.m_93694_() - 2) * guiScale);
        RenderSystem.enableScissor((int)scissorX, (int)scissorY, (int)scissorWidth, (int)scissorHeight);
        poseStack.m_85837_((double)this.m_252754_() + (double)this.m_5711_() / 2.0, (double)this.m_252907_() + (double)this.m_93694_() / 2.0, 100.0);
        poseStack.m_85837_(this.translateX * (double)this.scale, this.translateY * (double)this.scale, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(this.rotationY));
        poseStack.m_252781_(Axis.f_252495_.m_252977_(this.rotationX));
        poseStack.m_85841_(this.scale, -this.scale, this.scale);
        poseStack.m_252781_(new Quaternionf().rotationXYZ((float)Math.toRadians(25.0), (float)Math.toRadians(225.0), 0.0f));
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        if (WorkstationScreen.currentMode == Mode.SINGLE_BLOCK) {
            poseStack.m_85841_(2.0f, 2.0f, 2.0f);
            poseStack.m_85837_(-0.25, -0.25, -0.25);
        } else if (WorkstationScreen.currentMode == Mode.TWO_BY_TWO_BLOCK) {
            poseStack.m_85837_(-0.25, -0.25, -0.25);
        } else if (WorkstationScreen.currentMode == Mode.VERTICAL_BLOCK) {
            poseStack.m_85837_(0.0, -0.5, 0.0);
        } else if (WorkstationScreen.currentMode == Mode.HORIZONTAL_BLOCK) {
            poseStack.m_85837_(-0.5, -0.375, 0.0);
        } else if (WorkstationScreen.currentMode == Mode.HORIZONTAL_ALT_BLOCK) {
            poseStack.m_85837_(-0.75, -0.375, 1.0);
        }
        fakeLevel.renderBlocks(poseStack);
        poseStack.m_85849_();
        RenderSystem.disableScissor();
    }

    public void m_5716_(double mouseX, double mouseY) {
        FakeLevel fakeLevel;
        if (this.currentState == null && (fakeLevel = this.fakeLevelSupplier.get()) != null) {
            this.currentState = fakeLevel.m_8055_(BlockPos.f_121853_);
        }
        if (this.currentState != null) {
            this.cycleBlockState();
        }
        super.m_5716_(mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY)) {
            if (button == 0) {
                this.isDragging = true;
                this.isDraggingStarted = false;
            } else if (button == 1) {
                this.isRightDragging = true;
            }
            this.lastMouseX = (int)mouseX;
            this.lastMouseY = (int)mouseY;
            this.mouseDownTime = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isDragging) {
            this.isDragging = false;
            long clickDuration = System.currentTimeMillis() - this.mouseDownTime;
            if (!this.isDraggingStarted && clickDuration < 100L && this.m_5953_(mouseX, mouseY)) {
                this.m_5716_(mouseX, mouseY);
            }
            this.isDraggingStarted = false;
            return true;
        }
        if (button == 1 && this.isRightDragging) {
            this.isRightDragging = false;
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDragging && button == 0) {
            int deltaX = (int)(mouseX - (double)this.lastMouseX);
            int deltaY = (int)(mouseY - (double)this.lastMouseY);
            this.rotationY += (float)deltaX * 2.0f;
            this.rotationX += (float)deltaY * 2.0f;
            this.rotationY %= 360.0f;
            this.rotationX = Mth.m_14036_((float)this.rotationX, (float)-45.0f, (float)0.0f);
            if (this.rotationY < 0.0f) {
                this.rotationY += 360.0f;
            }
            this.lastMouseX = (int)mouseX;
            this.lastMouseY = (int)mouseY;
            return true;
        }
        if (this.isRightDragging && button == 1) {
            double deltaX = mouseX - (double)this.lastMouseX;
            double deltaY = mouseY - (double)this.lastMouseY;
            this.translateX += deltaX * 0.01;
            this.translateY += deltaY * 0.01;
            this.lastMouseX = (int)mouseX;
            this.lastMouseY = (int)mouseY;
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.scale += (float)(scrollY * 0.5);
            this.scale = Mth.m_14036_((float)this.scale, (float)5.0f, (float)40.0f);
            return true;
        }
        return super.m_6050_(mouseX, mouseY, scrollY);
    }

    private void cycleBlockState() {
        if (this.currentState != null && this.currentState.m_61138_((Property)BlockStateProperties.f_61446_)) {
            BlockState newState;
            boolean isOpen = (Boolean)this.currentState.m_61143_((Property)BlockStateProperties.f_61446_);
            this.currentState = newState = (BlockState)this.currentState.m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(!isOpen));
            this.onStateChange.accept(newState);
        }
    }

    public void setCurrentState(BlockState state) {
        this.currentState = state;
    }

    protected void m_168797_(NarrationElementOutput narrationElementOutput) {
    }

    public static enum Mode {
        SINGLE_BLOCK(new BlockPos[]{BlockPos.f_121853_}, new Direction[]{Direction.NORTH}),
        L_SHAPE_BLOCK(new BlockPos[]{BlockPos.f_121853_, BlockPos.f_121853_.m_122012_(), BlockPos.f_121853_.m_122029_()}, new Direction[]{Direction.NORTH, Direction.EAST, Direction.NORTH}),
        VERTICAL_BLOCK(new BlockPos[]{BlockPos.f_121853_, BlockPos.f_121853_.m_7494_()}, new Direction[]{Direction.NORTH, Direction.NORTH}),
        HORIZONTAL_BLOCK(new BlockPos[]{BlockPos.f_121853_, BlockPos.f_121853_.m_122029_()}, new Direction[]{Direction.NORTH, Direction.NORTH}),
        HORIZONTAL_ALT_BLOCK(new BlockPos[]{BlockPos.f_121853_, BlockPos.f_121853_.m_122012_()}, new Direction[]{Direction.NORTH, Direction.NORTH}),
        TWO_BY_TWO_BLOCK(new BlockPos[]{BlockPos.f_121853_, BlockPos.f_121853_.m_122029_(), BlockPos.f_121853_.m_7494_(), BlockPos.f_121853_.m_122029_().m_7494_()}, new Direction[]{Direction.NORTH, Direction.NORTH, Direction.NORTH, Direction.NORTH});

        private final List<BlockPos> positions;
        private final List<Direction> directions;

        private Mode(BlockPos[] positions, Direction[] directions) {
            this.positions = List.of(positions);
            this.directions = List.of(directions);
        }

        public List<BlockPos> getPositions() {
            return this.positions;
        }

        public List<Direction> getDirections() {
            return this.directions;
        }
    }

    public static enum FenceConfiguration {
        SINGLE(EnumSet.noneOf(Direction.class)),
        NORTH_SOUTH(EnumSet.of(Direction.NORTH, Direction.SOUTH)),
        EAST_WEST(EnumSet.of(Direction.EAST, Direction.WEST)),
        CORNER_NE(EnumSet.of(Direction.NORTH, Direction.EAST)),
        CORNER_NW(EnumSet.of(Direction.NORTH, Direction.WEST)),
        CORNER_SE(EnumSet.of(Direction.SOUTH, Direction.EAST)),
        CORNER_SW(EnumSet.of(Direction.SOUTH, Direction.WEST)),
        T_SHAPE_N(EnumSet.of(Direction.NORTH, Direction.EAST, Direction.WEST)),
        T_SHAPE_S(EnumSet.of(Direction.SOUTH, Direction.EAST, Direction.WEST)),
        T_SHAPE_E(EnumSet.of(Direction.NORTH, Direction.SOUTH, Direction.EAST)),
        T_SHAPE_W(EnumSet.of(Direction.NORTH, Direction.SOUTH, Direction.WEST)),
        CROSS(EnumSet.allOf(Direction.class));

        private final EnumSet<Direction> connections;

        private FenceConfiguration(EnumSet<Direction> connections) {
            this.connections = connections;
        }

        public BlockState applyToBlockState(BlockState state) {
            return state;
        }
    }
}

