/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.client.util.forge;

import dev.architectury.fluid.FluidStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import org.jetbrains.annotations.Nullable;

public class FluidRenderUtilImpl {
    public static TextureAtlasSprite[] getSprites(Fluid fluid) {
        TextureAtlasSprite flowingSprite;
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
        ResourceLocation stillTexture = extensions.getStillTexture();
        ResourceLocation flowingTexture = extensions.getFlowingTexture();
        TextureAtlas blockAtlas = (TextureAtlas)Minecraft.m_91087_().m_91097_().m_118506_(InventoryMenu.f_39692_);
        TextureAtlasSprite stillSprite = stillTexture != null ? blockAtlas.m_118316_(stillTexture) : null;
        TextureAtlasSprite textureAtlasSprite = flowingSprite = flowingTexture != null ? blockAtlas.m_118316_(flowingTexture) : null;
        if (stillSprite == null && flowingSprite == null) {
            return null;
        }
        return new TextureAtlasSprite[]{stillSprite, flowingSprite};
    }

    public static int getColor(FluidStack fluidStack, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos) {
        int color;
        FluidState stateInWorld;
        IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        FluidState fluidState = null;
        if (level != null && pos != null && (stateInWorld = level.m_6425_(pos)).m_192917_(fluidStack.getFluid())) {
            fluidState = stateInWorld;
        }
        if (fluidState == null) {
            fluidState = fluidStack.getFluid().m_76145_();
        }
        return (color = extensions.getTintColor(fluidState, level, pos)) != -1 ? color : -1;
    }
}

