/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.lyivx.ls_furniture.common.items.WrenchItem;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CabinetOvenVentBlock
extends Block
implements WrenchItem.WrenchableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final VoxelShape NORTH = Stream.of(Block.m_49796_((double)1.0, (double)-1.0, (double)9.0, (double)2.0, (double)0.0, (double)15.9), Block.m_49796_((double)14.0, (double)-1.0, (double)9.0, (double)15.0, (double)0.0, (double)15.9), Block.m_49796_((double)2.0, (double)-1.0, (double)15.0, (double)14.0, (double)0.0, (double)15.9), Block.m_49796_((double)2.0, (double)-1.0, (double)9.0, (double)14.0, (double)0.0, (double)10.0), Block.m_49796_((double)2.0, (double)-0.75, (double)10.0, (double)14.0, (double)0.0, (double)15.0), Block.m_49796_((double)9.5, (double)-0.8249999999999993, (double)8.9, (double)10.0, (double)-0.22499999999999964, (double)9.2), Block.m_49796_((double)8.5, (double)-0.8249999999999993, (double)8.9, (double)9.0, (double)-0.22499999999999964, (double)9.2), Block.m_49796_((double)6.0, (double)-0.8249999999999993, (double)8.9, (double)7.5, (double)-0.22499999999999964, (double)9.2), Block.m_49796_((double)0.0, (double)-2.0, (double)15.0, (double)16.0, (double)0.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)1.0, (double)10.0), Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)10.0, (double)1.0, (double)1.0, (double)15.0), Block.m_49796_((double)15.0, (double)0.0, (double)10.0, (double)16.0, (double)1.0, (double)15.0), Block.m_49796_((double)0.0, (double)1.0, (double)9.0, (double)16.0, (double)15.0, (double)16.0), Block.m_49796_((double)0.0, (double)15.0, (double)9.0, (double)16.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final BooleanProperty ON = BooleanProperty.m_61465_((String)"on");
    private static final VoxelShape[] SHAPES = new VoxelShape[4];

    public CabinetOvenVentBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(state -> (Boolean)state.m_61143_((Property)ON) != false ? 15 : 0));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ON, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ON, FACING});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return SHAPES[direction.m_122416_()];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)ON, (Comparable)Boolean.valueOf(false));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        ItemStack itemStack = player.m_21120_(hand);
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof WrenchItem) {
            return InteractionResult.FAIL;
        }
        BlockState newState = (BlockState)state.m_61122_((Property)ON);
        level.m_46597_(pos, newState);
        level.m_5594_(null, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, (Boolean)newState.m_61143_((Property)ON) != false ? 0.6f : 0.5f);
        return InteractionResult.SUCCESS;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    @Override
    public List<Property<?>> getWrenchableProperties() {
        return List.of(FACING);
    }

    static {
        CabinetOvenVentBlock.SHAPES[0] = ShapeUtil.rotateShape(NORTH, Direction.SOUTH);
        CabinetOvenVentBlock.SHAPES[1] = ShapeUtil.rotateShape(NORTH, Direction.WEST);
        CabinetOvenVentBlock.SHAPES[2] = ShapeUtil.rotateShape(NORTH, Direction.NORTH);
        CabinetOvenVentBlock.SHAPES[3] = ShapeUtil.rotateShape(NORTH, Direction.EAST);
    }
}

