/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.lyivx.ls_furniture.common.blocks.ModStairBlock;
import net.lyivx.ls_furniture.common.blocks.entity.LockableBlockEntity;
import net.lyivx.ls_furniture.common.blocks.properties.ModBlockStateProperties;
import net.lyivx.ls_furniture.common.items.HammerItem;
import net.lyivx.ls_furniture.common.items.WrenchItem;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.lyivx.ls_furniture.common.utils.block.ILockable;
import net.lyivx.ls_furniture.registry.ModBlocksTags;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PlatformBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
WrenchItem.WrenchableBlock,
HammerItem.HammerableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty NORTH_PLATFORM = ModBlockStateProperties.NORTH_PLATFORM;
    public static final BooleanProperty EAST_PLATFORM = ModBlockStateProperties.EAST_PLATFORM;
    public static final BooleanProperty SOUTH_PLATFORM = ModBlockStateProperties.SOUTH_PLATFORM;
    public static final BooleanProperty WEST_PLATFORM = ModBlockStateProperties.WEST_PLATFORM;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty UPDATE = ModBlockStateProperties.UPDATE;
    protected static final VoxelShape BOTTOM = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape PLATFORM_NORTH = Stream.of(Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), Block.m_49796_((double)3.0, (double)1.0, (double)0.0, (double)5.0, (double)14.0, (double)2.0), Block.m_49796_((double)11.0, (double)1.0, (double)0.0, (double)13.0, (double)14.0, (double)2.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape PLATFORM_EAST = ShapeUtil.rotateShape(PLATFORM_NORTH, Direction.EAST);
    protected static final VoxelShape PLATFORM_SOUTH = ShapeUtil.rotateShape(PLATFORM_NORTH, Direction.SOUTH);
    protected static final VoxelShape PLATFORM_WEST = ShapeUtil.rotateShape(PLATFORM_NORTH, Direction.WEST);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{BOTTOM, Shapes.m_83110_((VoxelShape)BOTTOM, (VoxelShape)PLATFORM_NORTH), Shapes.m_83110_((VoxelShape)BOTTOM, (VoxelShape)PLATFORM_EAST), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{PLATFORM_NORTH, PLATFORM_EAST}), Shapes.m_83110_((VoxelShape)BOTTOM, (VoxelShape)PLATFORM_SOUTH), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{PLATFORM_NORTH, PLATFORM_SOUTH}), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{PLATFORM_EAST, PLATFORM_SOUTH}), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{PLATFORM_NORTH, PLATFORM_EAST, PLATFORM_SOUTH}), Shapes.m_83110_((VoxelShape)BOTTOM, (VoxelShape)PLATFORM_WEST), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{PLATFORM_NORTH, PLATFORM_WEST}), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{PLATFORM_EAST, PLATFORM_WEST}), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{PLATFORM_NORTH, PLATFORM_EAST, PLATFORM_WEST}), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{PLATFORM_SOUTH, PLATFORM_WEST}), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{PLATFORM_NORTH, PLATFORM_SOUTH, PLATFORM_WEST}), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{PLATFORM_EAST, PLATFORM_SOUTH, PLATFORM_WEST}), Shapes.m_83124_((VoxelShape)BOTTOM, (VoxelShape[])new VoxelShape[]{PLATFORM_NORTH, PLATFORM_EAST, PLATFORM_SOUTH, PLATFORM_WEST})};

    public PlatformBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)NORTH_PLATFORM, (Comparable)Boolean.valueOf(true))).m_61124_((Property)EAST_PLATFORM, (Comparable)Boolean.valueOf(true))).m_61124_((Property)SOUTH_PLATFORM, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WEST_PLATFORM, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        int shape = 0;
        if (((Boolean)state.m_61143_((Property)NORTH_PLATFORM)).booleanValue()) {
            ++shape;
        }
        if (((Boolean)state.m_61143_((Property)EAST_PLATFORM)).booleanValue()) {
            shape += 2;
        }
        if (((Boolean)state.m_61143_((Property)SOUTH_PLATFORM)).booleanValue()) {
            shape += 4;
        }
        if (((Boolean)state.m_61143_((Property)WEST_PLATFORM)).booleanValue()) {
            shape += 8;
        }
        return SHAPES[shape];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
        return this.getConnections(state, (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        ILockable lockable;
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if ((blockEntity = level.m_7702_(currentPos)) instanceof ILockable && (lockable = (ILockable)blockEntity).isLocked()) {
            return state;
        }
        return this.getConnections(state, level, currentPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, NORTH_PLATFORM, EAST_PLATFORM, SOUTH_PLATFORM, WEST_PLATFORM, UPDATE, WATERLOGGED});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof HammerItem || item instanceof WrenchItem) {
            return InteractionResult.FAIL;
        }
        if (!(item instanceof BlockItem)) {
            return InteractionResult.FAIL;
        }
        BlockItem blockItem = (BlockItem)item;
        Block blockInHand = blockItem.m_40614_();
        if (!(blockInHand instanceof PlatformBlock) && !(blockInHand instanceof ModStairBlock)) {
            return InteractionResult.FAIL;
        }
        if (hit.m_82434_() != Direction.UP) {
            return InteractionResult.FAIL;
        }
        Direction playerFacing = player.m_6350_();
        BlockPos targetPos = pos.m_121945_(playerFacing);
        if (!this.canPlaceBlock(level, targetPos)) {
            return InteractionResult.FAIL;
        }
        if (blockInHand instanceof ModStairBlock) {
            return this.placeStairBlock(level, targetPos, blockInHand, playerFacing, player, stack);
        }
        if (blockInHand instanceof PlatformBlock) {
            return this.placePlatformBlock(level, targetPos, blockInHand, (Direction)state.m_61143_((Property)FACING), player, stack);
        }
        return InteractionResult.SUCCESS;
    }

    private boolean canPlaceBlock(Level level, BlockPos targetPos) {
        return level.m_8055_(targetPos).m_247087_() && level.m_8055_(targetPos.m_7494_()).m_247087_();
    }

    private InteractionResult placeStairBlock(Level level, BlockPos pos, Block block, Direction playerFacing, Player player, ItemStack stack) {
        BlockState newState = (BlockState)((BlockState)block.m_49966_().m_61124_((Property)FACING, (Comparable)playerFacing.m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
        BlockState typeNewState = (BlockState)((BlockState)((BlockState)block.m_49966_().m_61124_((Property)FACING, (Comparable)playerFacing.m_122424_())).m_61124_(ModStairBlock.MODEL_TYPE, (Comparable)((Object)ModStairBlock.StairModelType.TOP))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
        level.m_7731_(pos, newState, 3);
        level.m_7731_(pos.m_7494_(), typeNewState, 3);
        this.playPlaceSound(level, pos, block);
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        newState.m_60701_((LevelAccessor)level, pos, 3);
        return InteractionResult.SUCCESS;
    }

    private InteractionResult placePlatformBlock(Level level, BlockPos pos, Block block, Direction blockFacing, Player player, ItemStack stack) {
        BlockState newState = (BlockState)((BlockState)block.m_49966_().m_61124_((Property)FACING, (Comparable)blockFacing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(pos).m_76152_() == Fluids.f_76193_));
        level.m_7731_(pos, newState, 3);
        this.playPlaceSound(level, pos, block);
        if (!player.m_7500_()) {
            stack.m_41774_(1);
        }
        newState.m_60701_((LevelAccessor)level, pos, 3);
        return InteractionResult.SUCCESS;
    }

    private void playPlaceSound(Level level, BlockPos pos, Block block) {
        SoundType soundType = block.m_49962_(block.m_49966_());
        level.m_5594_(null, pos, soundType.m_56777_(), SoundSource.BLOCKS, (soundType.m_56773_() + 1.0f) / 2.0f, soundType.m_56774_() * 0.8f);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        boolean north_1 = (Boolean)state.m_61143_((Property)NORTH_PLATFORM);
        boolean east_1 = (Boolean)state.m_61143_((Property)EAST_PLATFORM);
        boolean south_1 = (Boolean)state.m_61143_((Property)SOUTH_PLATFORM);
        boolean west_1 = (Boolean)state.m_61143_((Property)WEST_PLATFORM);
        return switch (rotation) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)NORTH_PLATFORM, (Comparable)Boolean.valueOf(west_1))).m_61124_((Property)EAST_PLATFORM, (Comparable)Boolean.valueOf(north_1))).m_61124_((Property)SOUTH_PLATFORM, (Comparable)Boolean.valueOf(east_1))).m_61124_((Property)WEST_PLATFORM, (Comparable)Boolean.valueOf(south_1));
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)NORTH_PLATFORM, (Comparable)Boolean.valueOf(south_1))).m_61124_((Property)EAST_PLATFORM, (Comparable)Boolean.valueOf(west_1))).m_61124_((Property)SOUTH_PLATFORM, (Comparable)Boolean.valueOf(north_1))).m_61124_((Property)WEST_PLATFORM, (Comparable)Boolean.valueOf(east_1));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)NORTH_PLATFORM, (Comparable)Boolean.valueOf(east_1))).m_61124_((Property)EAST_PLATFORM, (Comparable)Boolean.valueOf(south_1))).m_61124_((Property)SOUTH_PLATFORM, (Comparable)Boolean.valueOf(west_1))).m_61124_((Property)WEST_PLATFORM, (Comparable)Boolean.valueOf(north_1));
        };
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public BlockState getConnections(BlockState state, LevelAccessor level, BlockPos pos) {
        boolean north = this.validConnection(level.m_8055_(pos.m_122012_()));
        boolean east = this.validConnection(level.m_8055_(pos.m_122029_()));
        boolean south = this.validConnection(level.m_8055_(pos.m_122019_()));
        boolean west = this.validConnection(level.m_8055_(pos.m_122024_()));
        boolean north_1 = !north || !this.validConnection(level.m_8055_(pos.m_122012_().m_122019_()));
        boolean east_1 = !east || !this.validConnection(level.m_8055_(pos.m_122029_().m_122024_()));
        boolean south_1 = !south || !this.validConnection(level.m_8055_(pos.m_122019_().m_122012_()));
        boolean west_1 = !west || !this.validConnection(level.m_8055_(pos.m_122024_().m_122029_()));
        boolean update = ((north ? 1 : 0) + (east ? 1 : 0) + (south ? 1 : 0) + (west ? 1 : 0)) % 2 == 0;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)NORTH_PLATFORM, (Comparable)Boolean.valueOf(north_1))).m_61124_((Property)EAST_PLATFORM, (Comparable)Boolean.valueOf(east_1))).m_61124_((Property)SOUTH_PLATFORM, (Comparable)Boolean.valueOf(south_1))).m_61124_((Property)WEST_PLATFORM, (Comparable)Boolean.valueOf(west_1))).m_61124_((Property)UPDATE, (Comparable)Boolean.valueOf(update));
    }

    public boolean validConnection(BlockState state) {
        return state.m_204336_(ModBlocksTags.PLATFORMS_CONNECTABLE);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.connectable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.lockable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.hammerable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    @Override
    public List<Property<?>> getHammerableProperties() {
        return List.of(NORTH_PLATFORM, EAST_PLATFORM, SOUTH_PLATFORM, WEST_PLATFORM);
    }

    @Override
    public List<Property<?>> getWrenchableProperties() {
        return List.of(FACING);
    }

    @Override
    public BlockState updateAfterCycle(BlockState state, LevelAccessor level, BlockPos pos) {
        return WrenchItem.WrenchableBlock.super.updateAfterCycle(state, level, pos);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new LockableBlockEntity(pos, state);
    }
}

