/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.lyivx.ls_furniture.common.blocks.entity.RailingBlockEntity;
import net.lyivx.ls_furniture.common.blocks.properties.ModBlockStateProperties;
import net.lyivx.ls_furniture.common.items.HammerItem;
import net.lyivx.ls_furniture.common.items.SawItem;
import net.lyivx.ls_furniture.common.items.WrenchItem;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.lyivx.ls_furniture.common.utils.block.ILockable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RailingBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
WrenchItem.WrenchableBlock,
HammerItem.HammerableBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty NORTH_RAILING = ModBlockStateProperties.NORTH_RAILING;
    public static final BooleanProperty EAST_RAILING = ModBlockStateProperties.EAST_RAILING;
    public static final BooleanProperty SOUTH_RAILING = ModBlockStateProperties.SOUTH_RAILING;
    public static final BooleanProperty WEST_RAILING = ModBlockStateProperties.WEST_RAILING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final BooleanProperty UPDATE = ModBlockStateProperties.UPDATE;
    protected static final VoxelShape RAILING_NORTH = Stream.of(Block.m_49796_((double)3.0, (double)0.0, (double)0.0, (double)5.0, (double)14.0, (double)2.0), Block.m_49796_((double)11.0, (double)0.0, (double)0.0, (double)13.0, (double)14.0, (double)2.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    protected static final VoxelShape RAILING_EAST = ShapeUtil.rotateShape(RAILING_NORTH, Direction.EAST);
    protected static final VoxelShape RAILING_SOUTH = ShapeUtil.rotateShape(RAILING_NORTH, Direction.SOUTH);
    protected static final VoxelShape RAILING_WEST = ShapeUtil.rotateShape(RAILING_NORTH, Direction.WEST);

    public RailingBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)NORTH_RAILING, (Comparable)Boolean.valueOf(true))).m_61124_((Property)EAST_RAILING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH_RAILING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST_RAILING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape = Shapes.m_83040_();
        if (((Boolean)state.m_61143_((Property)NORTH_RAILING)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)RAILING_NORTH);
        }
        if (((Boolean)state.m_61143_((Property)EAST_RAILING)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)RAILING_EAST);
        }
        if (((Boolean)state.m_61143_((Property)SOUTH_RAILING)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)RAILING_SOUTH);
        }
        if (((Boolean)state.m_61143_((Property)WEST_RAILING)).booleanValue()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)RAILING_WEST);
        }
        return shape;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_();
        boolean waterlogged = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        boolean railing1 = false;
        boolean railing2 = false;
        boolean railing3 = false;
        boolean railing4 = false;
        switch (facing) {
            case NORTH: {
                railing1 = true;
                break;
            }
            case SOUTH: {
                railing3 = true;
                break;
            }
            case EAST: {
                railing2 = true;
                break;
            }
            case WEST: {
                railing4 = true;
                break;
            }
            default: {
                railing1 = false;
                railing2 = false;
                railing3 = false;
                railing4 = false;
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)NORTH_RAILING, (Comparable)Boolean.valueOf(railing1))).m_61124_((Property)EAST_RAILING, (Comparable)Boolean.valueOf(railing2))).m_61124_((Property)SOUTH_RAILING, (Comparable)Boolean.valueOf(railing3))).m_61124_((Property)WEST_RAILING, (Comparable)Boolean.valueOf(railing4))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ILockable lockable;
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof HammerItem || item instanceof WrenchItem || item instanceof SawItem) {
            return InteractionResult.FAIL;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof ILockable && (lockable = (ILockable)blockEntity).isLocked()) {
            player.m_5661_((Component)Component.m_237115_((String)"msg.ls_furniture.locked"), true);
            return InteractionResult.FAIL;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (!player.m_7500_()) {
            player.m_21120_(hand).m_41774_(1);
        }
        Direction hitFace = hit.m_82434_();
        Vec3 hitPosition = hit.m_82450_();
        double xOffset = hitPosition.f_82479_ - (double)pos.m_123341_();
        double zOffset = hitPosition.f_82481_ - (double)pos.m_123343_();
        if (item == this.m_5456_()) {
            if (xOffset > 0.01 && xOffset < 0.99 && zOffset > 0.01 && zOffset < 0.99) {
                if (hitFace == Direction.SOUTH && zOffset < 0.5) {
                    if (xOffset < 0.5) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)WEST_RAILING, (Comparable)Boolean.valueOf(true)), 3);
                        return InteractionResult.SUCCESS;
                    }
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)EAST_RAILING, (Comparable)Boolean.valueOf(true)), 3);
                    return InteractionResult.SUCCESS;
                }
                if (hitFace == Direction.WEST) {
                    if (xOffset < 0.5) {
                        return InteractionResult.SUCCESS;
                    }
                    if (zOffset < 0.5) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)NORTH_RAILING, (Comparable)Boolean.valueOf(true)), 3);
                        return InteractionResult.SUCCESS;
                    }
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)SOUTH_RAILING, (Comparable)Boolean.valueOf(true)), 3);
                    return InteractionResult.SUCCESS;
                }
                if (hitFace == Direction.EAST) {
                    if (xOffset < 0.5) {
                        if (zOffset < 0.5) {
                            level.m_7731_(pos, (BlockState)state.m_61124_((Property)NORTH_RAILING, (Comparable)Boolean.valueOf(true)), 3);
                            return InteractionResult.SUCCESS;
                        }
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)SOUTH_RAILING, (Comparable)Boolean.valueOf(true)), 3);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.SUCCESS;
                }
                if (hitFace == Direction.NORTH) {
                    if (zOffset < 0.5) {
                        return InteractionResult.SUCCESS;
                    }
                    if (xOffset < 0.5) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)WEST_RAILING, (Comparable)Boolean.valueOf(true)), 3);
                        return InteractionResult.SUCCESS;
                    }
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)EAST_RAILING, (Comparable)Boolean.valueOf(true)), 3);
                    return InteractionResult.SUCCESS;
                }
            } else {
                return InteractionResult.FAIL;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        ILockable lockable;
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if ((blockEntity = level.m_7702_(currentPos)) instanceof ILockable && (lockable = (ILockable)blockEntity).isLocked()) {
            return state;
        }
        return state;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, NORTH_RAILING, EAST_RAILING, SOUTH_RAILING, WEST_RAILING, UPDATE, WATERLOGGED});
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        boolean leg1 = (Boolean)state.m_61143_((Property)NORTH_RAILING);
        boolean leg2 = (Boolean)state.m_61143_((Property)EAST_RAILING);
        boolean leg3 = (Boolean)state.m_61143_((Property)SOUTH_RAILING);
        boolean leg4 = (Boolean)state.m_61143_((Property)WEST_RAILING);
        return switch (rotation) {
            default -> throw new IncompatibleClassChangeError();
            case Rotation.NONE -> (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)NORTH_RAILING, (Comparable)Boolean.valueOf(leg4))).m_61124_((Property)EAST_RAILING, (Comparable)Boolean.valueOf(leg1))).m_61124_((Property)SOUTH_RAILING, (Comparable)Boolean.valueOf(leg2))).m_61124_((Property)WEST_RAILING, (Comparable)Boolean.valueOf(leg3));
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)NORTH_RAILING, (Comparable)Boolean.valueOf(leg3))).m_61124_((Property)EAST_RAILING, (Comparable)Boolean.valueOf(leg4))).m_61124_((Property)SOUTH_RAILING, (Comparable)Boolean.valueOf(leg1))).m_61124_((Property)WEST_RAILING, (Comparable)Boolean.valueOf(leg2));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)))).m_61124_((Property)NORTH_RAILING, (Comparable)Boolean.valueOf(leg2))).m_61124_((Property)EAST_RAILING, (Comparable)Boolean.valueOf(leg3))).m_61124_((Property)SOUTH_RAILING, (Comparable)Boolean.valueOf(leg4))).m_61124_((Property)WEST_RAILING, (Comparable)Boolean.valueOf(leg1));
        };
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.connectable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.lockable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.hammerable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    @Override
    public List<Property<?>> getHammerableProperties() {
        return List.of(NORTH_RAILING, EAST_RAILING, SOUTH_RAILING, WEST_RAILING);
    }

    @Override
    public List<Property<?>> getWrenchableProperties() {
        return List.of(FACING);
    }

    @Override
    public BlockState updateAfterCycle(BlockState state, LevelAccessor level, BlockPos pos) {
        return WrenchItem.WrenchableBlock.super.updateAfterCycle(state, level, pos);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RailingBlockEntity(pos, state);
    }
}

