/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.lyivx.ls_core.common.utils.WoolHelper;
import net.lyivx.ls_furniture.common.blocks.SeatBlock;
import net.lyivx.ls_furniture.common.blocks.entity.LockableBlockEntity;
import net.lyivx.ls_furniture.common.blocks.properties.ColorType;
import net.lyivx.ls_furniture.common.blocks.properties.ModBlockStateProperties;
import net.lyivx.ls_furniture.common.blocks.properties.SofaType;
import net.lyivx.ls_furniture.common.items.HammerItem;
import net.lyivx.ls_furniture.common.items.WrenchItem;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.lyivx.ls_furniture.common.utils.block.ILockable;
import net.lyivx.ls_furniture.registry.ModItems;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SofaBlock
extends SeatBlock
implements SimpleWaterloggedBlock,
WrenchItem.WrenchableBlock,
HammerItem.HammerableBlock,
EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final EnumProperty<SofaType> SHAPE = ModBlockStateProperties.SOFA_TYPE;
    public static final EnumProperty<ColorType> COLOR = ModBlockStateProperties.COLOR;
    public static final VoxelShape SEAT_BASE = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    public static final VoxelShape SEAT_BACK_SINGLE = Stream.of(Block.m_49796_((double)0.0, (double)2.0, (double)13.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)10.0, (double)13.5, (double)16.0, (double)12.0, (double)16.5), Block.m_49796_((double)0.0, (double)12.0, (double)14.25, (double)16.0, (double)14.0, (double)17.25), Block.m_49796_((double)0.0, (double)14.0, (double)15.0, (double)16.0, (double)16.0, (double)18.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SEAT_BACK_MIDDLE = Stream.of(Block.m_49796_((double)0.0, (double)2.0, (double)13.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)10.0, (double)13.5, (double)16.0, (double)12.0, (double)16.5), Block.m_49796_((double)0.0, (double)12.0, (double)14.25, (double)16.0, (double)14.0, (double)17.25), Block.m_49796_((double)0.0, (double)14.0, (double)15.0, (double)16.0, (double)16.0, (double)18.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SEAT_BACK_LEFT = Stream.of(Block.m_49796_((double)0.0, (double)2.0, (double)13.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)10.0, (double)13.5, (double)16.0, (double)12.0, (double)16.5), Block.m_49796_((double)0.0, (double)12.0, (double)14.25, (double)16.0, (double)14.0, (double)17.25), Block.m_49796_((double)0.0, (double)14.0, (double)15.0, (double)16.0, (double)16.0, (double)18.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape SEAT_BACK_RIGHT = Stream.of(Block.m_49796_((double)0.0, (double)2.0, (double)13.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)10.0, (double)13.5, (double)16.0, (double)12.0, (double)16.5), Block.m_49796_((double)0.0, (double)12.0, (double)14.25, (double)16.0, (double)14.0, (double)17.25), Block.m_49796_((double)0.0, (double)14.0, (double)15.0, (double)16.0, (double)16.0, (double)18.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    public static final VoxelShape LEG_BL = Block.m_49796_((double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)2.0, (double)16.0);
    public static final VoxelShape LEG_BR = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)2.0, (double)2.0, (double)16.0);
    public static final VoxelShape LEG_FR = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)2.0, (double)2.0);
    public static final VoxelShape LEG_FL = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)2.0);
    public static final VoxelShape ARM_L = Block.m_49796_((double)13.0, (double)6.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
    public static final VoxelShape ARM_R = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)3.0, (double)10.0, (double)16.0);
    public static final VoxelShape SINGLE = Shapes.m_83124_((VoxelShape)SEAT_BASE, (VoxelShape[])new VoxelShape[]{SEAT_BACK_SINGLE, ARM_L, ARM_R, LEG_BL, LEG_BR, LEG_FL, LEG_FR});
    public static final VoxelShape SINGLE_EAST = ShapeUtil.rotateShape(SINGLE, Direction.EAST);
    public static final VoxelShape SINGLE_SOUTH = ShapeUtil.rotateShape(SINGLE, Direction.SOUTH);
    public static final VoxelShape SINGLE_WEST = ShapeUtil.rotateShape(SINGLE, Direction.WEST);
    public static final VoxelShape MIDDLE = Shapes.m_83110_((VoxelShape)SEAT_BASE, (VoxelShape)SEAT_BACK_MIDDLE);
    public static final VoxelShape MIDDLE_EAST = ShapeUtil.rotateShape(MIDDLE, Direction.EAST);
    public static final VoxelShape MIDDLE_SOUTH = ShapeUtil.rotateShape(MIDDLE, Direction.SOUTH);
    public static final VoxelShape MIDDLE_WEST = ShapeUtil.rotateShape(MIDDLE, Direction.WEST);
    public static final VoxelShape OUTER = Shapes.m_83124_((VoxelShape)SEAT_BASE, (VoxelShape[])new VoxelShape[]{LEG_FR, Stream.of(Block.m_49796_((double)12.45, (double)6.5, (double)15.5, (double)16.2, (double)10.0, (double)16.0), Block.m_49796_((double)12.95, (double)10.0, (double)15.5, (double)16.7, (double)12.0, (double)16.0), Block.m_49796_((double)13.7, (double)12.0, (double)15.5, (double)17.45, (double)14.0, (double)16.0), Block.m_49796_((double)14.45, (double)14.0, (double)15.5, (double)18.2, (double)16.0, (double)16.0), Block.m_49796_((double)15.5, (double)6.5, (double)12.45, (double)16.0, (double)10.0, (double)16.2), Block.m_49796_((double)15.5, (double)10.0, (double)12.95, (double)16.0, (double)12.0, (double)16.7), Block.m_49796_((double)15.5, (double)12.0, (double)13.7, (double)16.0, (double)14.0, (double)17.45), Block.m_49796_((double)15.5, (double)14.0, (double)14.45, (double)16.0, (double)16.0, (double)18.2)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get()});
    public static final VoxelShape OUTER_EAST = ShapeUtil.rotateShape(OUTER, Direction.EAST);
    public static final VoxelShape OUTER_SOUTH = ShapeUtil.rotateShape(OUTER, Direction.SOUTH);
    public static final VoxelShape OUTER_WEST = ShapeUtil.rotateShape(OUTER, Direction.WEST);
    public static final VoxelShape INNER = Shapes.m_83124_((VoxelShape)SEAT_BASE, (VoxelShape[])new VoxelShape[]{SEAT_BACK_MIDDLE, LEG_BL, LEG_BR, LEG_FL, Stream.of(Block.m_49796_((double)13.0, (double)2.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)13.5, (double)10.0, (double)0.0, (double)16.5, (double)12.0, (double)16.0), Block.m_49796_((double)14.25, (double)12.0, (double)0.0, (double)17.25, (double)14.0, (double)16.0), Block.m_49796_((double)15.0, (double)14.0, (double)0.0, (double)18.0, (double)16.0, (double)16.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get()});
    public static final VoxelShape INNER_EAST = ShapeUtil.rotateShape(INNER, Direction.EAST);
    public static final VoxelShape INNER_SOUTH = ShapeUtil.rotateShape(INNER, Direction.SOUTH);
    public static final VoxelShape INNER_WEST = ShapeUtil.rotateShape(INNER, Direction.WEST);
    public static final VoxelShape RIGHT = Shapes.m_83124_((VoxelShape)SEAT_BASE, (VoxelShape[])new VoxelShape[]{SEAT_BACK_RIGHT, ARM_R, LEG_BR, LEG_FR, LEG_BL});
    public static final VoxelShape RIGHT_EAST = ShapeUtil.rotateShape(RIGHT, Direction.EAST);
    public static final VoxelShape RIGHT_SOUTH = ShapeUtil.rotateShape(RIGHT, Direction.SOUTH);
    public static final VoxelShape RIGHT_WEST = ShapeUtil.rotateShape(RIGHT, Direction.WEST);
    public static final VoxelShape LEFT = Shapes.m_83124_((VoxelShape)SEAT_BASE, (VoxelShape[])new VoxelShape[]{SEAT_BACK_LEFT, ARM_L, LEG_BL, LEG_FL, LEG_BR});
    public static final VoxelShape LEFT_EAST = ShapeUtil.rotateShape(LEFT, Direction.EAST);
    public static final VoxelShape LEFT_SOUTH = ShapeUtil.rotateShape(LEFT, Direction.SOUTH);
    public static final VoxelShape LEFT_WEST = ShapeUtil.rotateShape(LEFT, Direction.WEST);

    public SofaBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(COLOR, (Comparable)((Object)ColorType.DEFAULT)));
    }

    @Override
    public float seatHeight(BlockState state) {
        return 0.2f;
    }

    @Override
    public BlockPos primaryDismountLocation(Level level, BlockState state, BlockPos pos) {
        Direction facingRelative;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState stateRelative = level.m_8055_(pos.m_121945_(facing));
        if (stateRelative.m_60734_() instanceof SofaBlock && facing != (facingRelative = (Direction)stateRelative.m_61143_((Property)FACING))) {
            return pos.m_121945_(facing).m_121945_(facingRelative);
        }
        return pos.m_121945_(facing);
    }

    @Override
    public float setRiderRotation(BlockState state, Entity entity) {
        float corner = switch ((SofaType)((Object)state.m_61143_(SHAPE))) {
            case SofaType.INNER_LEFT, SofaType.OUTER_LEFT -> -45.0f;
            case SofaType.INNER_RIGHT, SofaType.OUTER_RIGHT -> 45.0f;
            default -> 0.0f;
        };
        return ((Direction)state.m_61143_((Property)FACING)).m_122435_() + corner;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos blockPos = context.m_8083_();
        FluidState fluidState = context.m_43725_().m_6425_(blockPos);
        BlockState blockState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        return (BlockState)blockState.m_61124_(SHAPE, (Comparable)((Object)SofaBlock.getConnection(blockState, context.m_43725_(), blockPos)));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        ILockable lockable;
        BlockEntity blockEntity;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if ((blockEntity = level.m_7702_(currentPos)) instanceof ILockable && (lockable = (ILockable)blockEntity).isLocked()) {
            return state;
        }
        return direction.m_122434_().m_122479_() ? (BlockState)state.m_61124_(SHAPE, (Comparable)((Object)SofaBlock.getConnection(state, (Level)level, currentPos))) : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHAPE, WATERLOGGED, COLOR});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        SofaType shape = (SofaType)((Object)state.m_61143_(SHAPE));
        return switch (shape) {
            default -> throw new IncompatibleClassChangeError();
            case SofaType.SINGLE -> {
                switch (facing) {
                    case EAST: {
                        yield SINGLE_EAST;
                    }
                    case SOUTH: {
                        yield SINGLE_SOUTH;
                    }
                    case WEST: {
                        yield SINGLE_WEST;
                    }
                }
                yield SINGLE;
            }
            case SofaType.MIDDLE -> {
                switch (facing) {
                    case EAST: {
                        yield MIDDLE_EAST;
                    }
                    case SOUTH: {
                        yield MIDDLE_SOUTH;
                    }
                    case WEST: {
                        yield MIDDLE_WEST;
                    }
                }
                yield MIDDLE;
            }
            case SofaType.OUTER_LEFT -> {
                switch (facing) {
                    case EAST: {
                        yield OUTER_EAST;
                    }
                    case SOUTH: {
                        yield OUTER_SOUTH;
                    }
                    case WEST: {
                        yield OUTER_WEST;
                    }
                }
                yield OUTER;
            }
            case SofaType.OUTER_RIGHT -> {
                switch (facing) {
                    case EAST: {
                        yield OUTER_SOUTH;
                    }
                    case SOUTH: {
                        yield OUTER_WEST;
                    }
                    case WEST: {
                        yield OUTER;
                    }
                }
                yield OUTER_EAST;
            }
            case SofaType.LEFT -> {
                switch (facing) {
                    case EAST: {
                        yield LEFT_EAST;
                    }
                    case SOUTH: {
                        yield LEFT_SOUTH;
                    }
                    case WEST: {
                        yield LEFT_WEST;
                    }
                }
                yield LEFT;
            }
            case SofaType.RIGHT -> {
                switch (facing) {
                    case EAST: {
                        yield RIGHT_EAST;
                    }
                    case SOUTH: {
                        yield RIGHT_SOUTH;
                    }
                    case WEST: {
                        yield RIGHT_WEST;
                    }
                }
                yield RIGHT;
            }
            case SofaType.INNER_RIGHT -> {
                switch (facing) {
                    case EAST: {
                        yield INNER_SOUTH;
                    }
                    case SOUTH: {
                        yield INNER_WEST;
                    }
                    case WEST: {
                        yield INNER;
                    }
                }
                yield INNER_EAST;
            }
            case SofaType.INNER_LEFT -> {
                switch (facing) {
                    case EAST: {
                        yield INNER_EAST;
                    }
                    case SOUTH: {
                        yield INNER_SOUTH;
                    }
                    case WEST: {
                        yield INNER_WEST;
                    }
                }
                yield INNER;
            }
        };
    }

    public static SofaType getConnection(BlockState state, Level level, BlockPos pos) {
        Direction dir2;
        Direction dir1;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState state1 = level.m_8055_(pos.m_121945_(facing));
        if (state1.m_60734_() instanceof SofaBlock && (dir1 = (Direction)state1.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && SofaBlock.isDifferentOrientation(state, level, pos, dir1.m_122424_())) {
            if (dir1 == facing.m_122428_()) {
                return SofaType.INNER_LEFT;
            }
            return SofaType.INNER_RIGHT;
        }
        BlockState state2 = level.m_8055_(pos.m_121945_(facing.m_122424_()));
        if (state2.m_60734_() instanceof SofaBlock && (dir2 = (Direction)state2.m_61143_((Property)FACING)).m_122434_() != ((Direction)state.m_61143_((Property)FACING)).m_122434_() && SofaBlock.isDifferentOrientation(state, level, pos, dir2)) {
            if (dir2 == facing.m_122428_()) {
                return SofaType.OUTER_LEFT;
            }
            return SofaType.OUTER_RIGHT;
        }
        boolean left = SofaBlock.canConnect(level, pos, ((Direction)state.m_61143_((Property)FACING)).m_122428_());
        boolean right = SofaBlock.canConnect(level, pos, ((Direction)state.m_61143_((Property)FACING)).m_122427_());
        if (left && right) {
            return SofaType.MIDDLE;
        }
        if (left) {
            return SofaType.LEFT;
        }
        if (right) {
            return SofaType.RIGHT;
        }
        return SofaType.SINGLE;
    }

    public static ColorType getColorTypeFromDye(DyeColor dyeColor) {
        for (ColorType colorType : ColorType.values()) {
            if (colorType.getDyeColor() != dyeColor) continue;
            return colorType;
        }
        return ColorType.WHITE;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        DyeColor dye;
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof HammerItem || item instanceof WrenchItem) {
            return InteractionResult.FAIL;
        }
        DyeColor woolDye = WoolHelper.getDyeColor((ItemLike)stack.m_41720_());
        if (woolDye != null && state.m_61143_(COLOR) == ColorType.DEFAULT) {
            ColorType newColorType = SofaBlock.getColorTypeFromDye(woolDye);
            state = (BlockState)state.m_61124_(COLOR, (Comparable)((Object)newColorType));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            level.m_7731_(pos, state, 3);
            level.m_7260_(pos, state, state, 3);
            return InteractionResult.SUCCESS;
        }
        Item item2 = stack.m_41720_();
        if (item2 instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item2;
            v0 = dyeItem.m_41089_();
        } else {
            v0 = dye = null;
        }
        if (dye != null && state.m_61143_(COLOR) != ColorType.DEFAULT) {
            ColorType newColorType = SofaBlock.getColorTypeFromDye(dye);
            state = (BlockState)state.m_61124_(COLOR, (Comparable)((Object)newColorType));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            level.m_7731_(pos, state, 3);
            level.m_7260_(pos, state, state, 3);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_(ModItems.SHEARS.get()) && state.m_61143_(COLOR) != ColorType.DEFAULT) {
            this.dropCushion(state, level, pos);
            state = (BlockState)state.m_61124_(COLOR, (Comparable)((Object)ColorType.DEFAULT));
            level.m_7731_(pos, state, 3);
            level.m_7260_(pos, state, state, 3);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new LockableBlockEntity(pos, state);
    }

    public void m_6810_(BlockState state, @NotNull Level level, @NotNull BlockPos pos, BlockState newState, boolean moving) {
        if (!state.m_60713_(newState.m_60734_())) {
            this.dropCushion(state, level, pos);
        }
        super.m_6810_(state, level, pos, newState, moving);
    }

    public static boolean canConnect(Level level, BlockPos pos, Direction direction) {
        BlockState state = level.m_8055_(pos.m_121945_(direction));
        return state.m_60734_() instanceof SofaBlock;
    }

    public static boolean isDifferentOrientation(BlockState state, Level level, BlockPos pos, Direction dir) {
        BlockState blockState = level.m_8055_(pos.m_121945_(dir));
        return !(blockState.m_60734_() instanceof SofaBlock) || blockState.m_61143_((Property)FACING) != state.m_61143_((Property)FACING);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.dyeable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.connectable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.lockable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.hammerable"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    public void dropCushion(BlockState state, Level level, BlockPos pos) {
        if (state.m_61138_(COLOR) && state.m_61143_(COLOR) != ColorType.DEFAULT) {
            Block block = WoolHelper.getBlock((DyeColor)((ColorType)((Object)state.m_61143_(COLOR))).getDyeColor());
            Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)(block != null ? block : Blocks.f_50041_)));
        }
    }

    @Override
    public List<Property<?>> getHammerableProperties() {
        return List.of(SHAPE);
    }

    @Override
    public List<Property<?>> getWrenchableProperties() {
        return List.of(FACING);
    }

    @Override
    public BlockState updateAfterCycle(BlockState state, LevelAccessor level, BlockPos pos) {
        return WrenchItem.WrenchableBlock.super.updateAfterCycle(state, level, pos);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        LockableBlockEntity lockable;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LockableBlockEntity && !(lockable = (LockableBlockEntity)blockEntity).isLocked()) {
            super.m_6861_(state, level, pos, block, fromPos, isMoving);
        }
    }
}

