/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks;

import java.util.List;
import java.util.stream.Stream;
import net.lyivx.ls_furniture.common.blocks.entity.ToasterBlockEntity;
import net.lyivx.ls_furniture.common.items.WrenchItem;
import net.lyivx.ls_furniture.common.utils.ShapeUtil;
import net.lyivx.ls_furniture.registry.ModItems;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToasterBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock,
WrenchItem.WrenchableBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty TOASTING = BooleanProperty.m_61465_((String)"toasting");
    protected static final VoxelShape NORTH = Stream.of(Block.m_49796_((double)3.0, (double)1.0, (double)8.0, (double)13.0, (double)2.0, (double)14.0), Block.m_49796_((double)3.0, (double)0.0, (double)8.0, (double)13.0, (double)1.0, (double)14.0), Block.m_49796_((double)3.0, (double)2.0, (double)8.0, (double)4.0, (double)6.0, (double)13.0), Block.m_49796_((double)12.0, (double)2.0, (double)9.0, (double)13.0, (double)6.0, (double)14.0), Block.m_49796_((double)4.0, (double)2.0, (double)8.0, (double)13.0, (double)6.0, (double)9.0), Block.m_49796_((double)4.0, (double)2.0, (double)10.0, (double)12.0, (double)6.0, (double)11.0), Block.m_49796_((double)3.0, (double)2.0, (double)13.0, (double)12.0, (double)6.0, (double)14.0), Block.m_49796_((double)4.0, (double)2.0, (double)11.0, (double)12.0, (double)6.0, (double)12.0), Shapes.m_83113_((VoxelShape)Block.m_49796_((double)2.0, (double)4.0, (double)11.5, (double)3.0, (double)5.0, (double)13.5), (VoxelShape)Block.m_49796_((double)2.0, (double)4.0, (double)8.5, (double)3.0, (double)5.0, (double)10.5), (BooleanOp)BooleanOp.f_82695_)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();
    private static final VoxelShape[] SHAPES = new VoxelShape[4];

    public ToasterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)TOASTING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FACING, TOASTING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        return SHAPES[direction.m_122416_()];
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ToasterBlockEntity(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof WrenchItem) {
            return InteractionResult.FAIL;
        }
        if (!level.m_5776_() && stack.m_41720_() == ModItems.SLICED_BREAD.get()) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            BlockState newState = (BlockState)state.m_61124_((Property)TOASTING, (Comparable)Boolean.valueOf(true));
            level.m_7731_(pos, newState, 3);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ToasterBlockEntity) {
                ((ToasterBlockEntity)blockEntity).startToasting();
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.blank"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.properties"));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.wrenchable"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.ls_furniture.screen.shift"));
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    @Override
    public List<Property<?>> getWrenchableProperties() {
        return List.of(FACING);
    }

    @Override
    public BlockState updateAfterCycle(BlockState state, LevelAccessor level, BlockPos pos) {
        return WrenchItem.WrenchableBlock.super.updateAfterCycle(state, level, pos);
    }

    static {
        ToasterBlock.SHAPES[0] = ShapeUtil.rotateShape(NORTH, Direction.SOUTH);
        ToasterBlock.SHAPES[1] = ShapeUtil.rotateShape(NORTH, Direction.WEST);
        ToasterBlock.SHAPES[2] = ShapeUtil.rotateShape(NORTH, Direction.NORTH);
        ToasterBlock.SHAPES[3] = ShapeUtil.rotateShape(NORTH, Direction.EAST);
    }
}

