/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.blocks.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

public abstract class LiquidHolderBlockEntity
extends BlockEntity {
    public static final int BUCKET_VOLUME = 1000;
    private Fluid fluid = Fluids.f_76191_;
    private int storedAmount = 0;
    private final int capacity;

    public LiquidHolderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int capacity) {
        super(type, pos, state);
        this.capacity = capacity;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public void setFluid(Fluid fluid) {
        if (fluid == Fluids.f_76191_) {
            this.setFluidAndAmount(Fluids.f_76191_, 0);
        } else {
            this.setFluidAndAmount(fluid, this.capacity);
        }
    }

    public void setFluidAndAmount(Fluid fluid, int amount) {
        boolean changed = false;
        if (this.fluid != fluid || this.storedAmount != amount) {
            this.fluid = fluid;
            this.storedAmount = Math.min(amount, this.capacity);
            if (this.storedAmount <= 0) {
                this.fluid = Fluids.f_76191_;
                this.storedAmount = 0;
            }
            changed = true;
        }
        if (changed) {
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public int getStoredAmount() {
        return this.storedAmount;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isEmpty() {
        return this.fluid == Fluids.f_76191_ || this.storedAmount <= 0;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.isEmpty()) {
            ResourceLocation fluidId = BuiltInRegistries.f_257020_.m_7981_((Object)this.fluid);
            if (fluidId != null) {
                tag.m_128359_("FluidName", fluidId.toString());
                tag.m_128405_("Amount", this.storedAmount);
            }
        } else {
            tag.m_128359_("FluidName", "minecraft:empty");
            tag.m_128405_("Amount", 0);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("FluidName")) {
            String fluidName = tag.m_128461_("FluidName");
            if (fluidName.equals("minecraft:empty")) {
                this.fluid = Fluids.f_76191_;
                this.storedAmount = 0;
            } else {
                this.fluid = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(fluidName));
                this.storedAmount = tag.m_128451_("Amount");
                if (this.storedAmount <= 0) {
                    this.fluid = Fluids.f_76191_;
                    this.storedAmount = 0;
                } else {
                    this.storedAmount = Math.min(this.storedAmount, this.capacity);
                }
            }
        } else {
            this.fluid = Fluids.f_76191_;
            this.storedAmount = 0;
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

