/*
 * Decompiled with CFR 0.152.
 */
package net.lyivx.ls_furniture.common.recipes;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.lyivx.ls_furniture.common.recipes.WorkstationRecipe;
import net.lyivx.ls_furniture.config.ConfigProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class RecipeSorter {
    private static final List<Item> REGISTRATION_ORDER = new ArrayList<Item>();
    private static boolean isInitialized = false;

    private static void initializeIfNeeded() {
        if (!isInitialized) {
            REGISTRATION_ORDER.addAll(BuiltInRegistries.f_257033_.m_123024_().toList());
            isInitialized = true;
        }
    }

    public static void sort(List<WorkstationRecipe> recipes, Level level) {
        RecipeSorter.initializeIfNeeded();
        if (ConfigProvider.shouldSortRecipes()) {
            recipes.sort(Comparator.comparingInt(recipe -> {
                Item resultItem = recipe.output().m_41720_();
                int index = REGISTRATION_ORDER.indexOf(resultItem);
                return index != -1 ? index : Integer.MAX_VALUE;
            }));
        } else {
            recipes.sort(Comparator.comparing(recipe -> recipe.output().m_41720_().m_5524_()));
        }
    }

    public static List<Item> getRegistrationOrder() {
        RecipeSorter.initializeIfNeeded();
        return new ArrayList<Item>(REGISTRATION_ORDER);
    }
}

