/*
 * Decompiled with CFR 0.152.
 */
package dev.schmarrn.lighty.mode;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.schmarrn.lighty.api.LightyColors;
import dev.schmarrn.lighty.api.LightyHelper;
import dev.schmarrn.lighty.api.LightyMode;
import dev.schmarrn.lighty.api.ModeManager;
import dev.schmarrn.lighty.config.Config;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LightLayer;

public class BoringCrossMode
extends LightyMode {
    @Override
    public void beforeCompute(BufferBuilder builder) {
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
    }

    @Override
    public void compute(ClientLevel world, BlockPos pos, BufferBuilder builder) {
        if (!LightyHelper.isBlocked(world.m_8055_(pos.m_7495_()), world.m_8055_(pos), world, pos.m_7495_(), pos)) {
            int blockLightLevel = world.m_45517_(LightLayer.BLOCK, pos);
            int skyLightLevel = world.m_45517_(LightLayer.SKY, pos);
            if (LightyHelper.isSafe(blockLightLevel) && !Config.getShowSafe()) {
                return;
            }
            int color = LightyColors.getARGB(blockLightLevel, skyLightLevel);
            float offset = LightyHelper.getOffset(world.m_8055_(pos), pos, world);
            if (offset == -1.0f) {
                return;
            }
            float x1 = pos.m_123341_();
            float x2 = (float)pos.m_123341_() + 1.0f;
            float y = (float)pos.m_123342_() + 0.005f + offset;
            float z1 = pos.m_123343_();
            float z2 = (float)pos.m_123343_() + 1.0f;
            int overlayBrightness = Config.getOverlayBrightness();
            int lightmap = LightTexture.m_109885_((int)overlayBrightness, (int)overlayBrightness);
            builder.m_5483_((double)x1, (double)y, (double)z1).m_193479_(color).m_7421_(0.0f, 0.0f).m_85969_(lightmap).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_5483_((double)x1, (double)y, (double)z2).m_193479_(color).m_7421_(0.0f, 1.0f).m_85969_(lightmap).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_5483_((double)x2, (double)y, (double)z2).m_193479_(color).m_7421_(1.0f, 1.0f).m_85969_(lightmap).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_5483_((double)x2, (double)y, (double)z1).m_193479_(color).m_7421_(1.0f, 0.0f).m_85969_(lightmap).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        }
    }

    @Override
    public void beforeRendering() {
        RenderType.m_110463_().m_110185_();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)new ResourceLocation("lighty", "textures/block/cross.png"));
        RenderSystem.enableDepthTest();
    }

    @Override
    public void afterRendering() {
        RenderSystem.disableDepthTest();
    }

    public static void init() {
        ModeManager.registerMode(new ResourceLocation("lighty", "boring_cross_mode"), new BoringCrossMode());
    }
}

