/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block_network.graph;

import com.hrznstudio.titanium.block_network.NetworkManager;
import com.hrznstudio.titanium.block_network.element.NetworkElement;
import com.hrznstudio.titanium.block_network.graph.NetworkGraphScannerRequest;
import com.hrznstudio.titanium.block_network.graph.NetworkGraphScannerResult;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class NetworkGraphScanner {
    private final Set<NetworkElement> foundElements = new HashSet<NetworkElement>();
    private final Set<NetworkElement> newElements = new HashSet<NetworkElement>();
    private final Set<NetworkElement> removedElements = new HashSet<NetworkElement>();
    private final Set<NetworkElement> currentElements;
    private final ResourceLocation requiredNetworkType;
    private final List<NetworkGraphScannerRequest> allRequests = new ArrayList<NetworkGraphScannerRequest>();
    private final Queue<NetworkGraphScannerRequest> requests = new ArrayDeque<NetworkGraphScannerRequest>();

    public NetworkGraphScanner(Set<NetworkElement> currentElements, ResourceLocation requiredNetworkType) {
        this.currentElements = currentElements;
        this.removedElements.addAll(currentElements);
        this.requiredNetworkType = requiredNetworkType;
    }

    public NetworkGraphScannerResult scanAt(Level level, BlockPos pos) {
        NetworkGraphScannerRequest request;
        this.addRequest(new NetworkGraphScannerRequest(level, pos, null, null));
        while ((request = this.requests.poll()) != null) {
            this.singleScanAt(request);
        }
        return new NetworkGraphScannerResult(this.foundElements, this.newElements, this.removedElements, this.allRequests);
    }

    private void singleScanAt(NetworkGraphScannerRequest request) {
        NetworkElement pipe = NetworkManager.get(request.getLevel()).getElement(request.getPos());
        if (pipe != null) {
            if (!this.requiredNetworkType.equals((Object)pipe.getNetworkType())) {
                return;
            }
            if (request.getDirection() != null && !pipe.canConnectFrom(request.getDirection().m_122424_())) {
                return;
            }
            if (this.foundElements.add(pipe)) {
                if (!this.currentElements.contains(pipe)) {
                    this.newElements.add(pipe);
                }
                this.removedElements.remove(pipe);
                request.setSuccessful(true);
                for (Direction dir : Direction.values()) {
                    if (!pipe.canConnectFrom(dir)) continue;
                    this.addRequest(new NetworkGraphScannerRequest(request.getLevel(), request.getPos().m_121945_(dir), dir, request));
                }
            }
        }
    }

    private void addRequest(NetworkGraphScannerRequest request) {
        this.requests.add(request);
        this.allRequests.add(request);
    }
}

