/*
 * Decompiled with CFR 0.152.
 */
package me.paulf.fairylights.server.feature.light;

import me.paulf.fairylights.server.feature.light.ColorLightBehavior;
import me.paulf.fairylights.server.feature.light.FixedColorBehavior;
import me.paulf.fairylights.server.feature.light.Light;
import me.paulf.fairylights.util.FLMth;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ColorChangingBehavior
implements ColorLightBehavior {
    private final float[] red;
    private final float[] green;
    private final float[] blue;
    private final float rate;
    private boolean powered;

    public ColorChangingBehavior(float[] red, float[] green, float[] blue, float rate) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.rate = rate;
    }

    @Override
    public float getRed(float delta) {
        return this.get(this.red, delta);
    }

    @Override
    public float getGreen(float delta) {
        return this.get(this.green, delta);
    }

    @Override
    public float getBlue(float delta) {
        return this.get(this.blue, delta);
    }

    private float get(float[] values, float delta) {
        float p = this.powered ? FLMth.mod((float)Util.m_137550_() * 0.02f * this.rate, (float)values.length) : 0.0f;
        int i = (int)p;
        return Mth.m_14179_((float)(p - (float)i), (float)values[i % values.length], (float)values[(i + 1) % values.length]);
    }

    @Override
    public void power(boolean powered, boolean now, Light<?> light) {
        this.powered = powered;
    }

    @Override
    public void tick(Level world, Vec3 origin, Light<?> light) {
    }

    public static ColorLightBehavior create(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return new FixedColorBehavior(1.0f, 1.0f, 1.0f);
        }
        ListTag list = tag.m_128437_("colors", 3);
        float[] red = new float[list.size()];
        float[] green = new float[list.size()];
        float[] blue = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            int color = list.m_128763_(i);
            red[i] = (float)(color >> 16 & 0xFF) / 255.0f;
            green[i] = (float)(color >> 8 & 0xFF) / 255.0f;
            blue[i] = (float)(color & 0xFF) / 255.0f;
        }
        return new ColorChangingBehavior(red, green, blue, (float)list.size() / 960.0f);
    }

    public static int animate(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag == null) {
            return 0xFFFFFF;
        }
        ListTag list = tag.m_128437_("colors", 3);
        if (list.isEmpty()) {
            return 0xFFFFFF;
        }
        if (list.size() == 1) {
            return list.m_128763_(0);
        }
        float p = FLMth.mod((float)Util.m_137550_() * 0.02f * ((float)list.size() / 960.0f), (float)list.size());
        int i = (int)p;
        int c0 = list.m_128763_(i % list.size());
        float r0 = (float)(c0 >> 16 & 0xFF) / 255.0f;
        float g0 = (float)(c0 >> 8 & 0xFF) / 255.0f;
        float b0 = (float)(c0 & 0xFF) / 255.0f;
        int c1 = list.m_128763_((i + 1) % list.size());
        float r1 = (float)(c1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(c1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(c1 & 0xFF) / 255.0f;
        return (int)(Mth.m_14179_((float)(p - (float)i), (float)r0, (float)r1) * 255.0f) << 16 | (int)(Mth.m_14179_((float)(p - (float)i), (float)g0, (float)g1) * 255.0f) << 8 | (int)(Mth.m_14179_((float)(p - (float)i), (float)b0, (float)b1) * 255.0f);
    }

    public static boolean exists(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128425_("colors", 9);
    }
}

