/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api;

import at.petrak.hexcasting.api.addldata.ADMediaHolder;
import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.castables.SpecialHandler;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.player.Sentinel;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.google.common.base.Suppliers;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HexAPI {
    public static final String MOD_ID = "hexcasting";
    public static final Logger LOGGER = LogManager.getLogger((String)"hexcasting");
    public static final Supplier<HexAPI> INSTANCE = Suppliers.memoize(() -> {
        try {
            return (HexAPI)Class.forName("at.petrak.hexcasting.common.impl.HexAPIImpl").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            LogManager.getLogger().warn("Unable to find HexAPIImpl, using a dummy");
            return new HexAPI(){};
        }
    });
    public static final ArmorMaterial DUMMY_ARMOR_MATERIAL = new ArmorMaterial(){

        public int m_266425_(ArmorItem.Type type) {
            return 0;
        }

        public int m_7366_(ArmorItem.Type type) {
            return 0;
        }

        public int m_6646_() {
            return 0;
        }

        @NotNull
        public SoundEvent m_7344_() {
            return SoundEvents.f_11678_;
        }

        @NotNull
        public Ingredient m_6230_() {
            return Ingredient.f_43901_;
        }

        public String m_6082_() {
            return "missingno";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    };
    public static final String RAVENMIND_USERDATA = HexAPI.modLoc("ravenmind").toString();
    public static final String OP_COUNT_USERDATA = HexAPI.modLoc("op_count").toString();
    public static final String MARKED_MOVED_USERDATA = HexAPI.modLoc("impulsed").toString();

    default public String getActionI18nKey(ResourceKey<ActionRegistryEntry> action) {
        return "hexcasting.action.%s".formatted(action.m_135782_().toString());
    }

    default public String getSpecialHandlerI18nKey(ResourceKey<SpecialHandler.Factory<?>> action) {
        return "hexcasting.special.%s".formatted(action.m_135782_().toString());
    }

    default public String getRawHookI18nKey(ResourceLocation name) {
        return "hexcasting.rawhook.%s".formatted(name);
    }

    default public Component getActionI18n(ResourceKey<ActionRegistryEntry> key, boolean isGreat) {
        return Component.m_237115_((String)this.getActionI18nKey(key)).m_130940_(isGreat ? ChatFormatting.GOLD : ChatFormatting.LIGHT_PURPLE);
    }

    default public Component getSpecialHandlerI18n(ResourceKey<SpecialHandler.Factory<?>> key) {
        return Component.m_237115_((String)this.getSpecialHandlerI18nKey(key)).m_130940_(ChatFormatting.LIGHT_PURPLE);
    }

    default public Component getRawHookI18n(ResourceLocation name) {
        return Component.m_237115_((String)this.getRawHookI18nKey(name)).m_130940_(ChatFormatting.LIGHT_PURPLE);
    }

    default public <T extends Entity> void registerSpecialVelocityGetter(EntityType<T> key, EntityVelocityGetter<T> getter) {
    }

    default public Vec3 getEntityVelocitySpecial(Entity entity) {
        return entity.m_20184_();
    }

    default public <T extends Mob> void registerCustomBrainsweepingBehavior(EntityType<T> key, Consumer<T> hook) {
    }

    default public Consumer<Mob> defaultBrainsweepingBehavior() {
        return mob -> {};
    }

    default public <T extends Mob> Consumer<T> getBrainsweepBehavior(EntityType<T> mobType) {
        return mob -> {};
    }

    default public void brainsweep(Mob mob) {
        Consumer<Mob> behavior;
        EntityType type = mob.m_6095_();
        Consumer<Mob> erasedBehavior = behavior = this.getBrainsweepBehavior(type);
        erasedBehavior.accept(mob);
        IXplatAbstractions.INSTANCE.setBrainsweepAddlData(mob);
    }

    default public boolean isBrainswept(Mob mob) {
        return IXplatAbstractions.INSTANCE.isBrainswept(mob);
    }

    @Nullable
    default public Sentinel getSentinel(ServerPlayer player) {
        return null;
    }

    @Nullable
    default public ADMediaHolder findMediaHolder(ItemStack stack) {
        return null;
    }

    default public FrozenPigment getColorizer(Player player) {
        return FrozenPigment.DEFAULT.get();
    }

    default public ArmorMaterial robesMaterial() {
        return DUMMY_ARMOR_MATERIAL;
    }

    public static HexAPI instance() {
        return INSTANCE.get();
    }

    public static ResourceLocation modLoc(String s) {
        return new ResourceLocation(MOD_ID, s);
    }

    @FunctionalInterface
    public static interface EntityVelocityGetter<T extends Entity> {
        public Vec3 getVelocity(T var1);
    }
}

