/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.common.command;

import at.petrak.hexcasting.api.casting.ActionRegistryEntry;
import at.petrak.hexcasting.api.casting.iota.PatternIota;
import at.petrak.hexcasting.api.casting.math.HexDir;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.mod.HexTags;
import at.petrak.hexcasting.api.utils.HexUtils;
import at.petrak.hexcasting.common.casting.PatternRegistryManifest;
import at.petrak.hexcasting.common.command.PatternResLocArgument;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.server.ScrungledPatternsSave;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ListPerWorldPatternsCommand {
    public static void add(LiteralArgumentBuilder<CommandSourceStack> cmd) {
        cmd.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"perWorldPatterns").requires(dp -> dp.m_6761_(2))).then(Commands.m_82127_((String)"list").executes(ctx -> ListPerWorldPatternsCommand.list((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"give").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"patternName", (ArgumentType)PatternResLocArgument.id()).executes(ctx -> ListPerWorldPatternsCommand.giveOne((CommandSourceStack)ctx.getSource(), ListPerWorldPatternsCommand.getDefaultTarget((CommandSourceStack)ctx.getSource()), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"patternName"), PatternResLocArgument.getPattern((CommandContext<CommandSourceStack>)ctx, "patternName")))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> ListPerWorldPatternsCommand.giveOne((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"patternName"), PatternResLocArgument.getPattern((CommandContext<CommandSourceStack>)ctx, "patternName"))))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"giveAll").executes(ctx -> ListPerWorldPatternsCommand.giveAll((CommandSourceStack)ctx.getSource(), ListPerWorldPatternsCommand.getDefaultTarget((CommandSourceStack)ctx.getSource())))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> ListPerWorldPatternsCommand.giveAll((CommandSourceStack)ctx.getSource(), EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"))))));
    }

    private static Collection<ServerPlayer> getDefaultTarget(CommandSourceStack source) {
        Entity entity = source.m_81373_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            return List.of(player);
        }
        return List.of();
    }

    private static int list(CommandSourceStack source) {
        Set keys = IXplatAbstractions.INSTANCE.getActionRegistry().m_214010_();
        List listing = keys.stream().sorted((a, b) -> ListPerWorldPatternsCommand.compareResLoc(a.m_135782_(), b.m_135782_())).toList();
        ServerLevel ow = source.m_81372_().m_7654_().m_129783_();
        source.m_288197_(() -> Component.m_237115_((String)"command.hexcasting.pats.listing"), false);
        for (ResourceKey key : listing) {
            HexPattern pat = PatternRegistryManifest.getCanonicalStrokesPerWorld((ResourceKey<ActionRegistryEntry>)key, ow);
            source.m_288197_(() -> Component.m_237113_((String)key.m_135782_().toString()).m_130946_(": ").m_7220_(new PatternIota(pat).display()), false);
        }
        return keys.size();
    }

    private static int giveAll(CommandSourceStack source, Collection<ServerPlayer> targets) {
        if (!targets.isEmpty()) {
            ServerLevel ow = source.m_81372_().m_7654_().m_129783_();
            ScrungledPatternsSave save = ScrungledPatternsSave.open(ow);
            Registry<ActionRegistryEntry> regi = IXplatAbstractions.INSTANCE.getActionRegistry();
            int count = 0;
            for (Map.Entry entry : regi.m_6579_()) {
                ResourceKey key = (ResourceKey)entry.getKey();
                if (!HexUtils.isOfTag(regi, key, HexTags.Actions.PER_WORLD_PATTERN)) continue;
                Pair<String, ScrungledPatternsSave.PerWorldEntry> found = save.lookupReverse((ResourceKey<ActionRegistryEntry>)key);
                String signature = (String)found.getFirst();
                HexDir startDir = ((ScrungledPatternsSave.PerWorldEntry)found.getSecond()).canonicalStartDir();
                HexPattern pat = HexPattern.fromAnglesUnchecked(signature, startDir);
                CompoundTag tag = new CompoundTag();
                tag.m_128359_("op_id", key.m_135782_().toString());
                tag.m_128365_("pattern", (Tag)pat.serializeToNBT());
                ItemStack stack = new ItemStack((ItemLike)HexItems.SCROLL_LARGE);
                stack.m_41751_(tag);
                for (ServerPlayer player : targets) {
                    ItemEntity stackEntity = player.m_36176_(stack, false);
                    if (stackEntity != null) {
                        stackEntity.m_32061_();
                        stackEntity.m_32052_(player.m_20148_());
                    }
                    ++count;
                }
            }
            int finalCount = count;
            source.m_288197_(() -> Component.m_237110_((String)"command.hexcasting.pats.all", (Object[])new Object[]{finalCount, targets.size() == 1 ? ((ServerPlayer)targets.iterator().next()).m_5446_() : Integer.valueOf(targets.size())}), true);
            return count;
        }
        return 0;
    }

    private static int giveOne(CommandSourceStack source, Collection<ServerPlayer> targets, ResourceLocation patternName, HexPattern pat) {
        if (!targets.isEmpty()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("op_id", patternName.toString());
            tag.m_128365_("pattern", (Tag)pat.serializeToNBT());
            ItemStack stack = new ItemStack((ItemLike)HexItems.SCROLL_LARGE);
            stack.m_41751_(tag);
            source.m_288197_(() -> Component.m_237110_((String)"command.hexcasting.pats.specific.success", (Object[])new Object[]{stack.m_41611_(), patternName, targets.size() == 1 ? ((ServerPlayer)targets.iterator().next()).m_5446_() : Integer.valueOf(targets.size())}), true);
            for (ServerPlayer player : targets) {
                ItemEntity stackEntity = player.m_36176_(stack, false);
                if (stackEntity == null) continue;
                stackEntity.m_32061_();
                stackEntity.m_32052_(player.m_20148_());
            }
            return targets.size();
        }
        return 0;
    }

    private static int compareResLoc(ResourceLocation a, ResourceLocation b) {
        int ns = a.m_135827_().compareTo(b.m_135827_());
        if (ns != 0) {
            return ns;
        }
        return a.m_135815_().compareTo(b.m_135815_());
    }
}

