/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark.elements.impl.table;

import dev.dediamondpro.resourcify.libs.minemark.LayoutData;
import dev.dediamondpro.resourcify.libs.minemark.LayoutStyle;
import dev.dediamondpro.resourcify.libs.minemark.elements.ChildMovingElement;
import dev.dediamondpro.resourcify.libs.minemark.elements.Element;
import dev.dediamondpro.resourcify.libs.minemark.elements.impl.table.TableRowElement;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public abstract class TableCellElement<S extends Style, R>
extends ChildMovingElement<S, R> {
    protected int rowIndex;
    protected int cellIndex;
    protected float cellHeight;
    protected Color fillColor;

    public TableCellElement(@NotNull S style, @NotNull LayoutStyle layoutStyle, @Nullable Element<S, R> parent, @NotNull String qName, @Nullable Attributes attributes) {
        super(style, layoutStyle, parent, qName, attributes);
        this.layoutStyle = this.layoutStyle.clone();
        if (qName.equals("th")) {
            this.layoutStyle.set(LayoutStyle.BOLD, true);
            this.layoutStyle.set(LayoutStyle.ALIGNMENT, LayoutStyle.Alignment.CENTER);
        }
        if (attributes != null && attributes.getValue("align") != null) {
            switch (attributes.getValue("align")) {
                case "left": {
                    this.layoutStyle.set(LayoutStyle.ALIGNMENT, LayoutStyle.Alignment.LEFT);
                    break;
                }
                case "center": {
                    this.layoutStyle.set(LayoutStyle.ALIGNMENT, LayoutStyle.Alignment.CENTER);
                    break;
                }
                case "right": {
                    this.layoutStyle.set(LayoutStyle.ALIGNMENT, LayoutStyle.Alignment.RIGHT);
                }
            }
        }
    }

    @Override
    protected void drawMarker(float x, float y, float markerWidth, float totalHeight, R renderData) {
        this.drawCellBackground(x, y, markerWidth, this.cellHeight, this.fillColor, renderData);
        float borderThickness = this.style.getTableStyle().getBorderThickness();
        if (this.rowIndex == 0) {
            this.drawBorderLine(x, y, markerWidth, borderThickness, this.style.getTableStyle().getBorderColor(), renderData);
        }
        this.drawBorderLine(x, y + this.cellHeight - borderThickness, markerWidth, borderThickness, this.style.getTableStyle().getBorderColor(), renderData);
        if (this.cellIndex == 0) {
            this.drawBorderLine(x, y, borderThickness, this.cellHeight, this.style.getTableStyle().getBorderColor(), renderData);
        }
        this.drawBorderLine(x + markerWidth - borderThickness, y, borderThickness, this.cellHeight, this.style.getTableStyle().getBorderColor(), renderData);
    }

    protected abstract void drawCellBackground(float var1, float var2, float var3, float var4, Color var5, R var6);

    protected abstract void drawBorderLine(float var1, float var2, float var3, float var4, Color var5, R var6);

    @Override
    public void generateLayout(LayoutData layoutData, R renderData) {
        super.generateLayout(layoutData, renderData);
        this.cellHeight = -1.0f;
    }

    @Override
    public void beforeDrawInternal(float xOffset, float yOffset, float mouseX, float mouseY, R renderData) {
        super.beforeDrawInternal(xOffset, yOffset, mouseX, mouseY, renderData);
        if (this.cellHeight != -1.0f) {
            return;
        }
        assert (this.parent != null);
        assert (this.parent.getParent() != null);
        this.cellHeight = ((TableRowElement)this.parent).cellHeight;
        this.rowIndex = this.parent.getParent().getChildren().indexOf(this.parent);
        this.cellIndex = this.parent.getChildren().indexOf(this);
        this.fillColor = this.rowIndex % 2 == 0 ? this.style.getTableStyle().getEvenFillColor() : this.style.getTableStyle().getOddFillColor();
    }

    @Override
    protected float getMarkerWidth(LayoutData layoutData, R renderData) {
        return 0.0f;
    }

    @Override
    protected float getInsidePadding(LayoutData layoutData, R renderData) {
        return this.style.getTableStyle().getInsidePadding();
    }

    @Override
    protected ChildMovingElement.MarkerType getMarkerType() {
        return ChildMovingElement.MarkerType.BLOCK;
    }
}

