/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.modifiers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeknights.mantle.data.listener.IEarlySafeManagerReloadListener;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.client.RenderUtils;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;

public class ModifierIconManager
implements IEarlySafeManagerReloadListener {
    private static final Logger log = LogManager.getLogger(ModifierIconManager.class);
    private static final String ICONS = "tinkering/modifier_icons.json";
    private static final ResourceLocation DEFAULT_PAGES = TConstruct.getResource("gui/modifiers/default_pages");
    private static final ResourceLocation DEFAULT_COVER = TConstruct.getResource("gui/modifiers/default_cover");
    public static final ModifierIconManager INSTANCE = new ModifierIconManager();
    private static Map<ModifierId, List<ResourceLocation>> modifierIcons = Collections.emptyMap();

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ModifierIconManager::onResourceManagerRegister);
    }

    private static void onResourceManagerRegister(RegisterClientReloadListenersEvent manager) {
        manager.registerReloadListener((PreparableReloadListener)INSTANCE);
    }

    public void onReloadSafe(ResourceManager manager) {
        HashMap<ModifierId, List<ResourceLocation>> icons = new HashMap<ModifierId, List<ResourceLocation>>();
        List jsonFiles = JsonHelper.getFileInAllDomainsAndPacks((ResourceManager)manager, (String)ICONS, null);
        for (int i = jsonFiles.size() - 1; i >= 0; --i) {
            JsonObject json = (JsonObject)jsonFiles.get(i);
            for (Map.Entry entry : json.entrySet()) {
                String key = (String)entry.getKey();
                ModifierId name = ModifierId.tryParse(key);
                if (name == null) {
                    log.error("Skipping invalid modifier key " + key + " as it is not a valid resource location");
                    continue;
                }
                if (icons.containsKey((Object)name)) continue;
                JsonElement element = (JsonElement)entry.getValue();
                if (element.isJsonNull()) {
                    icons.remove((Object)name);
                    continue;
                }
                if (element.isJsonArray()) {
                    JsonArray array = element.getAsJsonArray();
                    try {
                        icons.put(name, JsonHelper.parseList((JsonArray)array, (String)key, JsonHelper::convertToResourceLocation));
                    }
                    catch (JsonSyntaxException e) {
                        log.error("Skipping invalid modifier " + key + " due to error parsing path list: ", (Throwable)e);
                    }
                    continue;
                }
                if (element.isJsonPrimitive()) {
                    ResourceLocation path = ResourceLocation.m_135820_((String)element.getAsString());
                    if (path != null) {
                        icons.put(name, Collections.singletonList(path));
                        continue;
                    }
                    log.error("Skipping invalid modifier " + key + " as the path is invalid");
                    continue;
                }
                log.error("Skipping key " + key + " as the value is not a valid path");
            }
        }
        modifierIcons = icons;
    }

    public static void renderIcon(GuiGraphics graphics, Modifier modifier, int x, int y, int z, int size) {
        TextureAtlas atlas = Minecraft.m_91087_().m_91304_().m_119428_(InventoryMenu.f_39692_);
        List icons = modifierIcons.getOrDefault((Object)modifier.getId(), Collections.emptyList());
        if (!icons.isEmpty()) {
            for (ResourceLocation icon : icons) {
                graphics.m_280159_(x, y, z, size, size, atlas.m_118316_(icon));
            }
        } else {
            graphics.m_280159_(x, y, z, size, size, atlas.m_118316_(DEFAULT_PAGES));
            RenderUtils.setColorRGBA(0xFF000000 | modifier.getColor());
            graphics.m_280159_(x, y, z, size, size, atlas.m_118316_(DEFAULT_COVER));
            RenderUtils.setColorRGBA(-1);
        }
    }

    private ModifierIconManager() {
    }
}

