/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.tools.capability;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.modules.ModifierModule;
import slimeknights.tconstruct.library.modifiers.modules.build.ModifierTraitModule;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.CapacityStat;
import slimeknights.tconstruct.library.tools.stat.ToolStatId;
import slimeknights.tconstruct.tools.TinkerModifiers;

public record ToolEnergyCapability(Supplier<? extends IToolStackView> tool) implements IEnergyStorage
{
    public static final String ENERGY_FORMAT = TConstruct.makeDescriptionId("tool_stat", "energy");
    public static final CapacityStat MAX_STAT = new CapacityStat(new ToolStatId("tconstruct", "max_energy"), 0xA00000, ENERGY_FORMAT);
    public static final ResourceLocation ENERGY_KEY = TConstruct.getResource("energy");
    public static final ModifierModule ENERGY_HANDLER = new ModifierTraitModule(TinkerModifiers.energyHandler.getId(), 1, true);

    public static int getMaxEnergy(IToolStackView tool) {
        return tool.getStats().getInt(MAX_STAT);
    }

    public static int getEnergy(IToolStackView tool) {
        return tool.getPersistentData().getInt(ENERGY_KEY);
    }

    private static void setEnergyRaw(IToolStackView tool, int energy) {
        if (energy == 0) {
            tool.getPersistentData().remove(ENERGY_KEY);
        } else {
            tool.getPersistentData().putInt(ENERGY_KEY, energy);
        }
    }

    public static void setEnergy(IToolStackView tool, int energy) {
        ToolEnergyCapability.setEnergyRaw(tool, Mth.m_14045_((int)energy, (int)0, (int)ToolEnergyCapability.getMaxEnergy(tool)));
    }

    public static void checkEnergy(IToolStackView tool) {
        int energy = ToolEnergyCapability.getEnergy(tool);
        if (energy < 0) {
            ToolEnergyCapability.setEnergyRaw(tool, 0);
        } else {
            int capacity = ToolEnergyCapability.getMaxEnergy(tool);
            if (energy > capacity) {
                ToolEnergyCapability.setEnergyRaw(tool, capacity);
            }
        }
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (maxReceive <= 0) {
            return 0;
        }
        IToolStackView tool = this.tool.get();
        int current = ToolEnergyCapability.getEnergy(tool);
        int filled = Math.min(ToolEnergyCapability.getMaxEnergy(tool) - current, maxReceive);
        if (!simulate) {
            ToolEnergyCapability.setEnergyRaw(tool, current + filled);
        }
        return filled;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (maxExtract <= 0) {
            return 0;
        }
        IToolStackView tool = this.tool.get();
        int current = ToolEnergyCapability.getEnergy(tool);
        if (current <= 0) {
            return 0;
        }
        int drained = maxExtract;
        if (current < drained) {
            drained = current;
        }
        if (!simulate) {
            ToolEnergyCapability.setEnergyRaw(tool, current - drained);
        }
        return drained;
    }

    public int getEnergyStored() {
        return ToolEnergyCapability.getEnergy(this.tool.get());
    }

    public int getMaxEnergyStored() {
        return ToolEnergyCapability.getMaxEnergy(this.tool.get());
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public static class Provider
    implements ToolCapabilityProvider.IToolCapabilityProvider {
        private final LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> new ToolEnergyCapability(toolStack));

        public Provider(Supplier<? extends IToolStackView> toolStack) {
        }

        @Override
        public <T> LazyOptional<T> getCapability(IToolStackView tool, Capability<T> cap) {
            if (cap == ForgeCapabilities.ENERGY && tool.getStats().getInt(MAX_STAT) > 0) {
                return this.energyCap.cast();
            }
            return LazyOptional.empty();
        }
    }
}

