/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.world.entity;

import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.level.Level;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.materials.RandomMaterial;
import slimeknights.tconstruct.library.materials.definition.MaterialId;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierId;
import slimeknights.tconstruct.library.modifiers.ModifierManager;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.definition.ToolDefinition;
import slimeknights.tconstruct.library.tools.definition.module.material.ToolMaterialHook;
import slimeknights.tconstruct.library.tools.item.IModifiable;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.tools.TinkerTools;
import slimeknights.tconstruct.world.entity.ArmoredSlimeEntity;

public abstract class TravelersPlateSlimeEntity
extends ArmoredSlimeEntity {
    public TravelersPlateSlimeEntity(EntityType<? extends TravelersPlateSlimeEntity> type, Level world) {
        super(type, world);
    }

    protected abstract MaterialId getPlating();

    @Override
    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        float multiplier = difficulty.m_19057_();
        if (this.f_19796_.m_188501_() < 0.15f) {
            this.setMetal(true);
        }
        if (this.f_19796_.m_188501_() < 0.15f * multiplier) {
            IModifiable helmetItem = this.f_19796_.m_188501_() < 0.35f * multiplier ? (IModifiable)TinkerTools.plateArmor.get((Enum)ArmorItem.Type.HELMET) : (IModifiable)TinkerTools.travelersGear.get((Enum)ArmorItem.Type.HELMET);
            ToolDefinition definition = helmetItem.getToolDefinition();
            ToolStack tool = ToolStack.createTool(helmetItem.m_5456_(), definition, RandomMaterial.build(ToolMaterialHook.stats(definition), List.of(RandomMaterial.fixed(this.getPlating()), RandomMaterial.ancient()), random));
            ModifierNBT modifiers = tool.getUpgrades();
            ToolDataNBT persistentData = tool.getPersistentData();
            int max = tool.getFreeSlots(SlotType.DEFENSE);
            for (int i = 0; i < max && !(this.f_19796_.m_188501_() > 0.5f * multiplier); ++i) {
                persistentData.addSlots(SlotType.DEFENSE, -1);
                modifiers = modifiers.withModifier(TravelersPlateSlimeEntity.randomModifier(this.f_19796_, TinkerTags.Modifiers.SLIME_DEFENSE), 1);
            }
            if (tool.getFreeSlots(SlotType.UPGRADE) > 0 && this.f_19796_.m_188501_() < 0.5f * multiplier) {
                persistentData.addSlots(SlotType.UPGRADE, -1);
                modifiers = modifiers.withModifier(TravelersPlateSlimeEntity.randomModifier(this.f_19796_, TinkerTags.Modifiers.GEMS), 1);
            }
            tool.setUpgrades(modifiers);
            this.m_8061_(EquipmentSlot.HEAD, tool.createStack());
        }
    }

    private static ModifierId randomModifier(RandomSource random, TagKey<Modifier> tag) {
        List<Modifier> options = ModifierManager.getTagValues(tag);
        return options.get(random.m_188503_(options.size())).getId();
    }
}

