/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.item;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Either;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.PlatformHelper;
import io.github.mortuusars.exposure.item.AlbumPage;
import io.github.mortuusars.exposure.menu.AlbumMenu;
import io.github.mortuusars.exposure.util.ItemAndStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlbumItem
extends Item {
    public static final String TAG_PAGES = "Pages";
    public static final String TAG_TITLE = "Title";
    public static final String TAG_AUTHOR = "Author";

    public AlbumItem(Item.Properties properties) {
        super(properties);
    }

    public int getMaxPages() {
        return 16;
    }

    public boolean isEditable() {
        return true;
    }

    public Optional<AlbumPage> getPage(ItemStack albumStack, int index) {
        Preconditions.checkElementIndex((int)index, (int)this.getMaxPages());
        CompoundTag tag = albumStack.m_41783_();
        if (tag == null || tag.m_128456_() || !tag.m_128425_(TAG_PAGES, 9)) {
            return Optional.empty();
        }
        ListTag pagesTag = this.getOrCreatePagesTag(albumStack);
        return pagesTag.size() - 1 >= index ? Optional.ofNullable(AlbumPage.fromTag(pagesTag.m_128728_(index), this.isEditable())) : Optional.empty();
    }

    public void setPage(ItemStack albumStack, AlbumPage page, int index) {
        Preconditions.checkElementIndex((int)index, (int)this.getMaxPages());
        ListTag pagesTag = this.getOrCreatePagesTag(albumStack);
        while (pagesTag.size() - 1 < index) {
            pagesTag.add((Object)this.createEmptyPage().toTag(new CompoundTag()));
        }
        pagesTag.set(index, (Tag)page.toTag(new CompoundTag()));
    }

    public AlbumPage createEmptyPage() {
        return new AlbumPage(ItemStack.f_41583_, (Either<String, Component>)(this.isEditable() ? Either.left((Object)"") : Either.right((Object)Component.m_237119_())));
    }

    public List<AlbumPage> getPages(ItemStack albumStack) {
        CompoundTag tag = albumStack.m_41783_();
        if (tag == null || tag.m_128456_() || !tag.m_128425_(TAG_PAGES, 9)) {
            return Collections.emptyList();
        }
        ListTag pagesList = tag.m_128437_(TAG_PAGES, 10);
        if (pagesList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<AlbumPage> pages = new ArrayList<AlbumPage>();
        for (int i = 0; i < pagesList.size(); ++i) {
            pages.add(AlbumPage.fromTag(pagesList.m_128728_(i), this.isEditable()));
        }
        return pages;
    }

    public void addPage(ItemStack albumStack, AlbumPage page) {
        ListTag pages = this.getOrCreatePagesTag(albumStack);
        pages.add((Object)page.toTag(new CompoundTag()));
    }

    public void addPage(ItemStack albumStack, AlbumPage page, int index) {
        ListTag pages = this.getOrCreatePagesTag(albumStack);
        pages.add(index, (Tag)page.toTag(new CompoundTag()));
    }

    public int getPhotographsCount(ItemStack albumStack) {
        @Nullable CompoundTag tag = albumStack.m_41783_();
        if (tag == null || !tag.m_128425_(TAG_PAGES, 9)) {
            return 0;
        }
        int count = 0;
        ListTag pagesTag = tag.m_128437_(TAG_PAGES, 10);
        for (int i = 0; i < pagesTag.size(); ++i) {
            CompoundTag pageTag = pagesTag.m_128728_(i);
            if (!pageTag.m_128425_("Photo", 10)) continue;
            ++count;
        }
        return count;
    }

    protected ListTag getOrCreatePagesTag(ItemStack albumStack) {
        CompoundTag tag = albumStack.m_41784_();
        ListTag list = tag.m_128437_(TAG_PAGES, 10);
        tag.m_128365_(TAG_PAGES, (Tag)list);
        return list;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.m_21120_(usedHand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.open(serverPlayer, itemStack, this.isEditable());
        }
        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos blockPos = context.m_8083_();
        Level level = context.m_43725_();
        BlockState blockState = level.m_8055_(blockPos);
        if (blockState.m_60713_(Blocks.f_50624_)) {
            return LecternBlock.m_269125_((Entity)context.m_43723_(), (Level)level, (BlockPos)blockPos, (BlockState)blockState, (ItemStack)context.m_43722_()) ? InteractionResult.m_19078_((boolean)level.f_46443_) : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public void open(ServerPlayer player, final ItemStack albumStack, final boolean editable) {
        MenuProvider menuProvider = new MenuProvider(){

            @NotNull
            public Component m_5446_() {
                return albumStack.m_41786_();
            }

            @NotNull
            public AbstractContainerMenu m_7208_(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
                return new AlbumMenu(containerId, playerInventory, new ItemAndStack<AlbumItem>(albumStack), editable);
            }
        };
        PlatformHelper.openMenu(player, menuProvider, buffer -> {
            buffer.m_130055_(albumStack);
            buffer.writeBoolean(editable);
        });
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        int photographsCount;
        if (((Boolean)Config.Client.ALBUM_SHOW_PHOTOS_COUNT.get()).booleanValue() && (photographsCount = this.getPhotographsCount(stack)) > 0) {
            tooltipComponents.add((Component)Component.m_237110_((String)"item.exposure.album.tooltip.photos_count", (Object[])new Object[]{photographsCount}));
        }
    }

    public boolean shouldPlayEquipAnimation(ItemStack oldStack, ItemStack newStack) {
        return oldStack.m_41720_() != newStack.m_41720_();
    }

    public ItemStack sign(ItemStack album, String title, String author) {
        CompoundTag pageTag;
        AlbumPage page;
        int i;
        if (!(album.m_41720_() instanceof AlbumItem)) {
            throw new IllegalArgumentException("Can only sign AlbumItem's. Provided: '" + String.valueOf(album) + "'.");
        }
        if (!this.isEditable()) {
            throw new IllegalArgumentException("Cannot sign fixed album.");
        }
        ItemStack albumCopy = album.m_41777_();
        ListTag pagesTag = this.getOrCreatePagesTag(albumCopy);
        for (i = pagesTag.size() - 1; i >= 0 && (page = AlbumPage.fromTag(pageTag = pagesTag.m_128728_(i), this.isEditable())).isEmpty(); --i) {
            pagesTag.remove(i);
        }
        for (i = 0; i < pagesTag.size(); ++i) {
            AlbumPage page2 = AlbumPage.fromTag(pagesTag.m_128728_(i), this.isEditable());
            pagesTag.set(i, (Tag)page2.toSigned().toTag(new CompoundTag()));
        }
        ItemStack signedAlbum = new ItemStack((ItemLike)Exposure.Items.SIGNED_ALBUM.get());
        signedAlbum.m_41751_(albumCopy.m_41783_());
        signedAlbum.m_41784_().m_128359_(TAG_TITLE, title);
        signedAlbum.m_41784_().m_128359_(TAG_AUTHOR, author);
        return signedAlbum;
    }
}

