/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.entity.spells.ice_tomb;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.entity.spells.ice_tomb.IceTombEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class IceTombRenderer
extends EntityRenderer<IceTombEntity> {
    public static final ResourceLocation NOCULL = IronsSpellbooks.id("textures/entity/ice_tomb/ice_tomb.png");
    public static final ResourceLocation CULL = IronsSpellbooks.id("textures/entity/ice_tomb/ice_tomb_cull.png");
    private final IceTombModel model;

    public IceTombRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new IceTombModel(pContext.m_174023_(IceTombModel.LAYER_LOCATION));
    }

    public void render(IceTombEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-entity.m_146908_()));
        float xScaleFactor = entity.m_20205_() / entity.m_6095_().m_20680_().f_20377_;
        float yScaleFactor = entity.m_20206_() / entity.m_6095_().m_20680_().f_20378_;
        poseStack.m_85841_(xScaleFactor, -yScaleFactor, -xScaleFactor);
        poseStack.m_85837_(0.0, -1.501, 0.0);
        this.model.setupAnim(entity, partialTicks, 0.0f, 0.0f, entity.m_146908_(), entity.m_146909_());
        VertexConsumer vertexconsumer = multiBufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)NOCULL));
        this.model.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        vertexconsumer = multiBufferSource.m_6299_(RenderType.m_110470_((ResourceLocation)CULL));
        this.model.m_7695_(poseStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(IceTombEntity pEntity) {
        return NOCULL;
    }

    public static class IceTombModel
    extends EntityModel<IceTombEntity> {
        public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"ice_tomb"), "main");
        private final ModelPart model;

        public IceTombModel(ModelPart root) {
            this.model = root.m_171324_("model");
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.m_171576_();
            PartDefinition bb_main = partdefinition.m_171599_("model", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -36.0f, -8.0f, 16.0f, 36.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(40, 67).m_171488_(4.0f, -9.0f, 4.0f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 52).m_171488_(1.0f, -24.0f, -11.0f, 10.0f, 24.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(64, 0).m_171488_(-8.0f, -36.0f, -8.0f, 16.0f, 36.0f, 16.0f, new CubeDeformation(-0.01f)).m_171514_(40, 52).m_171488_(-10.0f, -9.0f, -10.0f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 86).m_171488_(-11.0f, -24.0f, 1.0f, 10.0f, 24.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
            return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
        }

        public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float r, float g, float b, float a) {
            this.model.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, r, g, b, a);
        }

        public void setupAnim(IceTombEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        }
    }
}

