/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.ender;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.network.particles.TeleportParticlesPacket;
import io.redspace.ironsspellbooks.setup.PacketDistributor;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TeleportSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"irons_spellbooks", (String)"teleport");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(SchoolRegistry.ENDER_RESOURCE).setMaxLevel(5).setCooldownSeconds(3.0).build();

    public TeleportSpell() {
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 10;
        this.baseManaCost = 20;
        this.manaCostPerLevel = 5;
        this.castTime = 0;
    }

    @Override
    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    @Override
    public CastType getCastType() {
        return CastType.INSTANT;
    }

    @Override
    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.f_11852_);
    }

    @Override
    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        Vec3 potentialTarget;
        TeleportData teleportData = (TeleportData)playerMagicData.getAdditionalCastData();
        Vec3 dest = null;
        if (teleportData != null && (potentialTarget = teleportData.getTeleportTargetPosition()) != null) {
            dest = potentialTarget;
        }
        if (dest == null) {
            dest = TeleportSpell.findTeleportLocation(level, entity, this.getDistance(spellLevel, entity));
        }
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, new TeleportParticlesPacket(entity.m_20182_(), dest));
        if (entity.m_20159_()) {
            entity.m_8127_();
        }
        Utils.handleSpellTeleport(this, (Entity)entity, dest);
        entity.m_183634_();
        playerMagicData.resetAdditionalCastData();
        entity.m_5496_(this.getCastFinishSound().get(), 2.0f, 1.0f);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public static Vec3 findTeleportLocation(Level level, LivingEntity entity, float maxDistance) {
        BlockHitResult blockHitResult = Utils.getTargetBlock(level, entity, ClipContext.Fluid.NONE, maxDistance);
        return TeleportSpell.solveTeleportDestination(level, entity, blockHitResult.m_82425_(), blockHitResult.m_82450_());
    }

    public static Vec3 solveTeleportDestination(Level level, LivingEntity entity, BlockPos blockPos, Vec3 vec3) {
        boolean los;
        BlockPos pos = blockPos;
        Vec3 bbOffset = entity.m_20156_().m_82541_().m_82542_((double)(entity.m_20205_() / 3.0f), 0.0, (double)(entity.m_20206_() / 3.0f));
        Vec3 bbImpact = vec3.m_82546_(bbOffset);
        double ledgeY = level.m_45547_((ClipContext)new ClipContext((Vec3)Vec3.m_82539_((Vec3i)pos).m_82520_((double)0.0, (double)3.0, (double)0.0), (Vec3)Vec3.m_82539_((Vec3i)pos), (ClipContext.Block)ClipContext.Block.COLLIDER, (ClipContext.Fluid)ClipContext.Fluid.NONE, null)).m_82450_().f_82480_;
        boolean isAir = level.m_8055_(new BlockPos(new Vec3i(pos.m_123341_(), (int)ledgeY, pos.m_123343_())).m_7494_()).m_60795_();
        boolean bl = los = level.m_45547_(new ClipContext(bbImpact, bbImpact.m_82520_(0.0, ledgeY - (double)pos.m_123342_(), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity)).m_6662_() == HitResult.Type.MISS;
        if (isAir && los && Math.abs(ledgeY - (double)pos.m_123342_()) <= 3.0) {
            return new Vec3((double)pos.m_123341_() + 0.5, ledgeY + 0.001, (double)pos.m_123343_() + 0.5);
        }
        return level.m_45547_(new ClipContext(bbImpact, bbImpact.m_82520_(0.0, (double)(-entity.m_20206_()), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity)).m_82450_().m_82520_(0.0, 0.001, 0.0);
    }

    public static void particleCloud(Level level, Vec3 pos) {
        if (level.f_46443_) {
            double width = 0.5;
            float height = 1.0f;
            for (int i = 0; i < 55; ++i) {
                double x = pos.f_82479_ + Utils.random.m_188500_() * width * 2.0 - width;
                double y = pos.f_82480_ + (double)height + Utils.random.m_188500_() * (double)height * 1.2 * 2.0 - (double)height * 1.2;
                double z = pos.f_82481_ + Utils.random.m_188500_() * width * 2.0 - width;
                double dx = Utils.random.m_188500_() * 0.1 * (double)(Utils.random.m_188499_() ? 1 : -1);
                double dy = Utils.random.m_188500_() * 0.1 * (double)(Utils.random.m_188499_() ? 1 : -1);
                double dz = Utils.random.m_188500_() * 0.1 * (double)(Utils.random.m_188499_() ? 1 : -1);
                level.m_6493_((ParticleOptions)ParticleTypes.f_123760_, true, x, y, z, dx, dy, dz);
            }
        }
    }

    private float getDistance(int spellLevel, LivingEntity sourceEntity) {
        return (float)(Utils.softCapFormula(this.getEntityPowerMultiplier(sourceEntity)) * (double)this.getSpellPower(spellLevel, null));
    }

    @Override
    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.distance", (Object[])new Object[]{Utils.stringTruncation(this.getDistance(spellLevel, caster), 1)}));
    }

    @Override
    public AnimationHolder getCastStartAnimation() {
        return AnimationHolder.none();
    }

    public static class TeleportData
    implements ICastData {
        private Vec3 teleportTargetPosition;

        public TeleportData(Vec3 teleportTargetPosition) {
            this.teleportTargetPosition = teleportTargetPosition;
        }

        public void setTeleportTargetPosition(Vec3 targetPosition) {
            this.teleportTargetPosition = targetPosition;
        }

        public Vec3 getTeleportTargetPosition() {
            return this.teleportTargetPosition;
        }

        @Override
        public void reset() {
        }
    }
}

