/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.misc;

import com.google.common.base.Suppliers;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.events.EarlyPackReloadEvent;
import net.mehvahdjukaar.moonlight.api.events.MoonlightEventsHelper;
import net.mehvahdjukaar.moonlight.api.misc.IProgressTracker;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynResourceGenerator;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.ReloadInstance;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ReloadInstanceWrapper
implements ReloadInstance {
    public static final Logger LOGGER = LogManager.getLogger((String)"ReloadInstanceWrapper");
    private final Supplier<ReloadInstance> lazyInstance;
    private final CompletableFuture<Unit> beforeTask;
    private final IProgressTracker.Tree progressTracker = IProgressTracker.createTree(1);

    public static ReloadInstance wrap(Supplier<ReloadInstance> factory, PackType type, ResourceManager manager, Executor backgroundExecutor) {
        return new ReloadInstanceWrapper(factory, type, manager, backgroundExecutor);
    }

    public static void executeEarlyReloadBlocking(PackType type, ResourceManager manager, IProgressTracker progressTracker) {
        DynResourceGenerator.clearBeforeReload(type);
        MoonlightEventsHelper.postEvent(new EarlyPackReloadEvent(List.of(), manager, type, progressTracker), EarlyPackReloadEvent.class);
    }

    public ReloadInstanceWrapper(Supplier<ReloadInstance> factory, PackType type, ResourceManager manager, Executor executor) {
        this.lazyInstance = Suppliers.memoize(factory::get);
        this.beforeTask = CompletableFuture.supplyAsync(() -> {
            ReloadInstanceWrapper.executeEarlyReloadBlocking(type, manager, this.progressTracker);
            return Unit.INSTANCE;
        }, executor);
    }

    @Nullable
    private ReloadInstance allErrorsInPackReloadWillHaveThisLineOnTheirStackTrace_DoesntMeanItsTheCause() {
        if (this.beforeTask.isDone() && !this.beforeTask.isCompletedExceptionally()) {
            return this.lazyInstance.get();
        }
        return null;
    }

    public CompletableFuture<?> m_7237_() {
        return this.beforeTask.thenCompose(unused -> {
            ReloadInstance actual = this.allErrorsInPackReloadWillHaveThisLineOnTheirStackTrace_DoesntMeanItsTheCause();
            return actual.m_7237_();
        });
    }

    public float m_7750_() {
        float maxAmount = Mth.m_14036_((float)0.2f, (float)0.0f, (float)0.5f);
        float progress = this.progressTracker.getProgress() * maxAmount;
        if (!this.beforeTask.isDone()) {
            return progress;
        }
        ReloadInstance actual = this.allErrorsInPackReloadWillHaveThisLineOnTheirStackTrace_DoesntMeanItsTheCause();
        if (actual != null) {
            return progress + actual.m_7750_() * (1.0f - maxAmount);
        }
        return 1.0f;
    }

    public void m_7748_() {
        ReloadInstance actual;
        if (!this.beforeTask.isDone()) {
            return;
        }
        if (this.beforeTask.isCompletedExceptionally()) {
            // empty if block
        }
        if ((actual = this.allErrorsInPackReloadWillHaveThisLineOnTheirStackTrace_DoesntMeanItsTheCause()) != null) {
            actual.m_7748_();
        }
    }
}

