/*
 * Decompiled with CFR 0.152.
 */
package org.teacon.xkdeco.client.model;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.teacon.xkdeco.block.XKDStateProperties;

public class AirDuctBakedModel
implements BakedModel {
    private final Cache<Pair<BlockState, Direction>, List<BakedQuad>> cache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).build();
    private final List<BakedModel> straight;
    private final List<BakedModel> corner;
    private final List<BakedModel> cover;
    private final BakedModel frame;

    public AirDuctBakedModel(List<BakedModel> straight, List<BakedModel> corner, List<BakedModel> cover, BakedModel frame) {
        this.straight = straight;
        this.corner = corner;
        this.cover = cover;
        this.frame = frame;
    }

    public List<BakedQuad> m_213637_(@Nullable BlockState blockState, @Nullable Direction direction, RandomSource randomSource) {
        if (blockState == null) {
            return this.straight.get(0).m_213637_(null, direction, randomSource);
        }
        try {
            return (List)this.cache.get((Object)Pair.of((Object)((BlockState)blockState.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))), (Object)direction), () -> {
                ArrayList trueDirections = Lists.newArrayListWithExpectedSize((int)6);
                for (int i = 0; i < 6; ++i) {
                    if (!((Boolean)blockState.m_61143_((Property)XKDStateProperties.DIRECTION_PROPERTIES.get(i))).booleanValue()) continue;
                    trueDirections.add(Direction.m_122376_((int)i));
                }
                if (trueDirections.size() == 2) {
                    Direction direction1 = (Direction)trueDirections.get(0);
                    Direction direction2 = (Direction)trueDirections.get(1);
                    if (direction1.m_122424_() == direction2) {
                        return this.straight.get(direction1.m_122434_().ordinal()).m_213637_(blockState, direction, randomSource);
                    }
                    int index = direction1 == Direction.DOWN ? 4 + direction2.m_122428_().m_122416_() : (direction1 == Direction.UP ? 8 + direction2.m_122428_().m_122416_() : (direction1 == Direction.SOUTH && direction2 == Direction.EAST ? 2 : (direction1.m_122416_() < direction2.m_122416_() ? direction1.m_122428_().m_122416_() : direction2.m_122428_().m_122416_())));
                    return this.corner.get(index).m_213637_(blockState, direction, randomSource);
                }
                ImmutableList.Builder quads = ImmutableList.builder();
                quads.addAll((Iterable)this.frame.m_213637_(blockState, direction, randomSource));
                for (int i = 0; i < 6; ++i) {
                    if (((Boolean)blockState.m_61143_((Property)XKDStateProperties.DIRECTION_PROPERTIES.get(i))).booleanValue()) continue;
                    quads.addAll((Iterable)this.cover.get(i).m_213637_(blockState, direction, randomSource));
                }
                return quads.build();
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean m_7541_() {
        return this.straight.get(0).m_7541_();
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return this.straight.get(0).m_7547_();
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite m_6160_() {
        return this.straight.get(0).m_6160_();
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

