/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.dummmmmmy.common.TargetDummyEntity;
import net.mehvahdjukaar.dummmmmmy.configs.ClientConfigs;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class TargetDummyModel<T extends TargetDummyEntity>
extends HumanoidModel<T> {
    public final ModelPart standPlate;
    private float bodyWobble = 0.0f;
    private float headSideWobble = 0.0f;
    private float rechargingAnim = 0.0f;

    public TargetDummyModel(ModelPart modelPart) {
        super(modelPart);
        this.standPlate = modelPart.m_171324_("stand");
    }

    public static LayerDefinition createMesh(float size, int textHeight) {
        CubeDeformation deformation = new CubeDeformation(size);
        MeshDefinition meshdefinition = HumanoidModel.m_170681_((CubeDeformation)deformation, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("stand", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171488_(-6.0f, 12.0f, -6.0f, 12.0f, 1.0f, 12.0f, deformation), PartPose.m_171419_((float)0.0f, (float)11.0f, (float)0.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, 1.0f, -2.0f, 4.0f, 8.0f, 4.0f, deformation.m_171469_(0.01f)), PartPose.m_171419_((float)-2.5f, (float)2.0f, (float)-0.005f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-1.0f, 1.0f, -2.0f, 4.0f, 8.0f, 4.0f, deformation.m_171469_(0.01f)), PartPose.m_171419_((float)2.5f, (float)2.0f, (float)-0.005f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation.m_171469_(size != 0.0f ? -0.01f : 0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)textHeight);
    }

    public void rotateModelX(ModelPart model, float pivotX, float pivotY, float pivotZ, float angle) {
        Vec3 oldRot = new Vec3((double)model.f_104200_, (double)model.f_104201_, (double)model.f_104202_);
        Vec3 actualRot = new Vec3((double)pivotX, (double)pivotY, (double)pivotZ);
        Vec3 newRot = actualRot.m_82549_(oldRot.m_82546_(actualRot).m_82496_(-angle));
        model.m_104227_((float)newRot.m_7096_(), (float)newRot.m_7098_(), (float)newRot.m_7094_());
        model.f_104203_ = angle;
    }

    public void rotateModelY(ModelPart model, float pivotX, float pivotY, float pivotZ, float angle, int mult) {
        Vec3 oldRot = new Vec3((double)model.f_104200_, (double)model.f_104201_, (double)model.f_104202_);
        Vec3 actualRot = new Vec3((double)pivotX, (double)pivotY, (double)pivotZ);
        Vec3 newRot = actualRot.m_82549_(oldRot.m_82546_(actualRot).m_82496_(-angle));
        model.m_104227_((float)newRot.m_7096_(), (float)newRot.m_7098_(), (float)newRot.m_7094_());
        model.f_104204_ = angle * (float)mult;
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int overlayIn, float r, float g, float b, float a) {
        int overlay = OverlayTexture.f_118083_;
        matrixStackIn.m_85836_();
        this.standPlate.m_104306_(matrixStackIn, bufferIn, packedLightIn, overlay, r, g, b, a);
        this.f_102808_.m_104306_(matrixStackIn, bufferIn, packedLightIn, overlay, r, g, b, a);
        this.f_102811_.m_104306_(matrixStackIn, bufferIn, packedLightIn, overlay, r, g, b, a);
        this.f_102812_.m_104306_(matrixStackIn, bufferIn, packedLightIn, overlay, r, g, b, a);
        this.f_102810_.m_104306_(matrixStackIn, bufferIn, packedLightIn, overlay, r, g, b, a);
        this.f_102814_.m_104306_(matrixStackIn, bufferIn, packedLightIn, overlay, r, g, b, a);
        this.f_102809_.m_104306_(matrixStackIn, bufferIn, packedLightIn, overlay, r, g, b, a);
        matrixStackIn.m_85849_();
    }

    public ModelPart getBody() {
        return this.f_102814_;
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        super.m_6839_(entity, limbSwing, limbSwingAmount, partialTick);
        float phase = ((TargetDummyEntity)((Object)entity)).getShake(partialTick);
        float unscaledSwingAmount = ((TargetDummyEntity)((Object)entity)).getAnimationPosition(partialTick);
        float swingAmount = Math.min((float)((double)unscaledSwingAmount * ClientConfigs.ANIMATION_INTENSITY.get()), 40.0f);
        if (swingAmount > 0.0f) {
            this.bodyWobble = (float)(-((double)Mth.m_14031_((float)phase) * Math.PI / 100.0 * (double)swingAmount));
            this.headSideWobble = (float)((double)Mth.m_14031_((float)phase) * Math.PI / 20.0 * (double)Math.min(swingAmount, 1.0f));
        } else {
            this.bodyWobble = 0.0f;
            this.headSideWobble = 0.0f;
        }
        this.standPlate.f_104203_ = 0.0f;
        this.standPlate.f_104204_ = (float)Math.PI / 180 * -Mth.m_14189_((float)partialTick, (float)((TargetDummyEntity)((Object)entity)).f_20884_, (float)((TargetDummyEntity)((Object)entity)).f_20883_);
        this.standPlate.f_104205_ = 0.0f;
        float recharge = ((TargetDummyEntity)((Object)entity)).getRechargingAnimation(partialTick);
        this.rechargingAnim = this.smoothRamp(recharge, 0.1);
    }

    private float smoothRamp(float number, double cutoff) {
        return (float)((double)number < cutoff ? (double)number / cutoff : 1.0);
    }

    public void setupAnim(TargetDummyEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float n = 1.5f;
        float yOffsetIn = -1.0f;
        float xangle = this.bodyWobble / 2.0f;
        this.f_102814_.m_104227_(0.0f, 12.0f + yOffsetIn, 0.0f);
        this.rotateModelX(this.f_102814_, 0.0f, 24.0f + yOffsetIn, 0.0f, xangle);
        this.f_102813_.m_104227_(0.0f, 12.0f + yOffsetIn, 0.0f);
        this.rotateModelX(this.f_102813_, 0.01f, 24.0f + yOffsetIn + 0.01f, 0.01f, xangle);
        this.f_102810_.m_104227_(0.0f, 0.0f + yOffsetIn, 0.0f);
        this.rotateModelX(this.f_102810_, 0.0f, 24.0f + yOffsetIn, 0.0f, xangle);
        this.f_102811_.m_104227_(-2.5f, 2.0f + yOffsetIn, -0.005f);
        this.rotateModelY(this.f_102811_, 0.0f, 24.0f + yOffsetIn, 0.0f, xangle, -1);
        this.f_102812_.m_104227_(2.5f, 2.0f + yOffsetIn, -0.005f);
        this.rotateModelY(this.f_102812_, 0.0f, 24.0f + yOffsetIn, 0.0f, xangle, 1);
        this.f_102808_.m_104227_(0.0f, 0.0f + yOffsetIn, 0.0f);
        this.rotateModelX(this.f_102808_, 0.0f, 24.0f + yOffsetIn, 0.0f, xangle);
        this.f_102808_.f_104203_ = -this.bodyWobble + this.rechargingAnim * 0.8f;
        this.f_102808_.f_104205_ = this.headSideWobble;
        this.f_102809_.m_104315_(this.f_102808_);
        this.f_102811_.f_104205_ = 1.5707964f;
        this.f_102812_.f_104205_ = -1.5707964f;
        this.f_102811_.f_104203_ = this.bodyWobble * n;
        this.f_102812_.f_104203_ = this.bodyWobble * n;
        this.f_102812_.f_104205_ += this.rechargingAnim * 0.25f;
        this.f_102811_.f_104205_ += this.rechargingAnim * -0.25f;
    }
}

