/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbase.modules.filter.items;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import mcjty.lib.varia.ItemStackList;
import mcjty.lib.varia.TagTools;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class FilterModuleInventory {
    private final ItemStackList stacks = ItemStackList.create();
    private final Set<TagKey<Item>> tags = new HashSet<TagKey<Item>>();
    private final Supplier<ItemStack> filterGetter;

    public FilterModuleInventory(Player player) {
        this.filterGetter = () -> player.m_21120_(InteractionHand.MAIN_HAND);
        CompoundTag tagCompound = player.m_21120_(InteractionHand.MAIN_HAND).m_41784_();
        this.convertFromNBT(tagCompound);
    }

    public FilterModuleInventory(ItemStack filterItem) {
        this.filterGetter = () -> filterItem;
        CompoundTag tagCompound = filterItem.m_41784_();
        this.convertFromNBT(tagCompound);
    }

    private void convertFromNBT(CompoundTag tagCompound) {
        Object s;
        ListTag itemList = tagCompound.m_128437_("Items", 10);
        for (int i = 0; i < itemList.size(); ++i) {
            CompoundTag compound = itemList.m_128728_(i);
            s = ItemStack.m_41712_((CompoundTag)compound);
            if (s.m_41619_()) continue;
            this.stacks.add(s);
        }
        ListTag tagList = tagCompound.m_128437_("Tags", 8);
        for (int i = 0; i < tagList.size(); ++i) {
            s = tagList.m_128778_(i);
            this.tags.add((TagKey<Item>)TagTools.createItemTagKey((ResourceLocation)new ResourceLocation((String)s)));
        }
    }

    public void addStack(ItemStack stack) {
        ItemStack toPlace = stack.m_41777_();
        toPlace.m_41764_(1);
        for (ItemStack s : this.stacks) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)s, (ItemStack)toPlace)) continue;
            return;
        }
        this.stacks.add((Object)toPlace);
    }

    public void removeStack(ItemStack stack) {
        for (int i = 0; i < this.stacks.size(); ++i) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)((ItemStack)this.stacks.get(i)))) continue;
            this.stacks.remove(i);
        }
    }

    public void removeStack(int idx) {
        this.stacks.remove(idx);
    }

    public void removeTag(TagKey<Item> id) {
        this.tags.remove(id);
    }

    public void addTag(TagKey<Item> id) {
        this.tags.add(id);
    }

    public List<ItemStack> getStacks() {
        return this.stacks;
    }

    public Set<TagKey<Item>> getTags() {
        return this.tags;
    }

    public void markDirty() {
        ItemStack heldItem = this.filterGetter.get();
        if (!heldItem.m_41619_()) {
            CompoundTag tagCompound = heldItem.m_41784_();
            ListTag itemList = new ListTag();
            for (ItemStack stack : this.stacks) {
                CompoundTag nbtTagCompound = new CompoundTag();
                if (!stack.m_41619_()) {
                    stack.m_41739_(nbtTagCompound);
                }
                itemList.add((Object)nbtTagCompound);
            }
            tagCompound.m_128365_("Items", (Tag)itemList);
            ListTag tagList = new ListTag();
            for (TagKey<Item> tag : this.tags) {
                tagList.add((Object)StringTag.m_129297_((String)tag.f_203868_().toString()));
            }
            tagCompound.m_128365_("Tags", (Tag)tagList);
        }
    }
}

