/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.quark.content.client.module;

import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.IntUnaryOperator;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetmoon.quark.base.QuarkClient;
import org.violetmoon.quark.content.client.module.VariantAnimalTexturesModule;
import org.violetmoon.quark.content.mobs.module.CrabsModule;
import org.violetmoon.quark.content.tools.module.SlimeInABucketModule;
import org.violetmoon.zeta.client.event.load.ZAddItemColorHandlers;
import org.violetmoon.zeta.client.event.load.ZClientSetup;
import org.violetmoon.zeta.config.Config;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.module.ZetaLoadModule;
import org.violetmoon.zeta.module.ZetaModule;
import org.violetmoon.zeta.util.ItemNBTHelper;

@ZetaLoadModule(category="client")
public class BucketsShowInhabitantsModule
extends ZetaModule {
    @Config
    public boolean showAxolotls = true;
    @Config
    public boolean showCrabs = true;
    @Config
    public boolean showTropicalFish = true;
    @Config
    public boolean showShinySlime = true;

    @ZetaLoadModule(clientReplacement=true)
    public static class Client
    extends BucketsShowInhabitantsModule {
        @LoadEvent
        public void clientSetup(ZClientSetup e) {
            e.enqueueWork(() -> {
                ItemProperties.register((Item)Items.f_151057_, (ResourceLocation)new ResourceLocation("quark", "variant"), (ItemPropertyFunction)new MobBucketVariantProperty(Axolotl.Variant.values().length, () -> this.showAxolotls));
                ItemProperties.register((Item)CrabsModule.crab_bucket, (ResourceLocation)new ResourceLocation("quark", "variant"), (ItemPropertyFunction)new MobBucketVariantProperty(3, () -> this.showCrabs));
                ItemProperties.register((Item)SlimeInABucketModule.slime_in_a_bucket, (ResourceLocation)new ResourceLocation("quark", "shiny"), (ItemPropertyFunction)new ShinyMobBucketProperty(() -> this.showShinySlime && VariantAnimalTexturesModule.staticEnabled && VariantAnimalTexturesModule.enableShinySlime));
                ItemProperties.register((Item)Items.f_42459_, (ResourceLocation)new ResourceLocation("quark", "base"), (ItemPropertyFunction)new TropicalFishBucketVariantProperty(b -> TropicalFish.m_30050_((int)b).m_41060_(), () -> this.showTropicalFish));
                ItemProperties.register((Item)Items.f_42459_, (ResourceLocation)new ResourceLocation("quark", "pattern"), (ItemPropertyFunction)new TropicalFishBucketVariantProperty(p -> TropicalFish.m_262390_((int)p).m_262435_(), () -> this.showTropicalFish));
            });
        }

        @LoadEvent
        public void registerItemColors(ZAddItemColorHandlers evt) {
            ItemColor parent = QuarkClient.ZETA_CLIENT.getItemColor(evt.getItemColors(), (ItemLike)Items.f_42459_);
            evt.register((ItemColor)new TropicalFishBucketColor(parent, () -> this.showTropicalFish), new ItemLike[]{Items.f_42459_});
        }

        private class TropicalFishBucketColor
        implements ItemColor {
            @Nullable
            private final ItemColor parent;
            private final BooleanSupplier featureEnabled;

            public TropicalFishBucketColor(ItemColor parent, BooleanSupplier featureEnabled) {
                this.parent = parent;
                this.featureEnabled = featureEnabled;
            }

            public int m_92671_(@NotNull ItemStack stack, int layer) {
                CompoundTag tag;
                if (Client.this.enabled && this.featureEnabled.getAsBoolean() && (layer == 1 || layer == 2) && (tag = stack.m_41783_()) != null && tag.m_128425_("BucketVariantTag", 3)) {
                    int variant = tag.m_128451_("BucketVariantTag");
                    DyeColor dyeColor = layer == 1 ? TropicalFish.m_30050_((int)variant) : TropicalFish.m_30052_((int)variant);
                    float[] colorComponents = dyeColor.m_41068_();
                    return (int)(colorComponents[0] * 255.0f) << 16 | (int)(colorComponents[1] * 255.0f) << 8 | (int)(colorComponents[2] * 255.0f);
                }
                return this.parent != null ? this.parent.m_92671_(stack, layer) : -1;
            }
        }

        private class MobBucketVariantProperty
        implements ItemPropertyFunction {
            private final int maxVariants;
            private final BooleanSupplier featureEnabled;

            public MobBucketVariantProperty(int maxVariants, BooleanSupplier featureEnabled) {
                this.maxVariants = maxVariants;
                this.featureEnabled = featureEnabled;
            }

            public float m_141951_(@NotNull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int id) {
                if (!Client.this.enabled || !this.featureEnabled.getAsBoolean()) {
                    return 0.0f;
                }
                return ItemNBTHelper.getInt((ItemStack)stack, (String)"Variant", (int)0) % this.maxVariants;
            }
        }

        private class ShinyMobBucketProperty
        implements ItemPropertyFunction {
            private final BooleanSupplier featureEnabled;

            public ShinyMobBucketProperty(BooleanSupplier featureEnabled) {
                this.featureEnabled = featureEnabled;
            }

            public float m_141951_(@NotNull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int id) {
                UUID uuid;
                if (!Client.this.enabled || !this.featureEnabled.getAsBoolean()) {
                    return 0.0f;
                }
                CompoundTag data = ItemNBTHelper.getCompound((ItemStack)stack, (String)"slime_nbt", (boolean)true);
                if (data != null && data.m_128403_("UUID") && VariantAnimalTexturesModule.Client.isShiny(uuid = data.m_128342_("UUID"))) {
                    return 1.0f;
                }
                return 0.0f;
            }
        }

        private class TropicalFishBucketVariantProperty
        implements ItemPropertyFunction {
            private final IntUnaryOperator extractor;
            private final BooleanSupplier featureEnabled;

            public TropicalFishBucketVariantProperty(IntUnaryOperator extractor, BooleanSupplier featureEnabled) {
                this.extractor = extractor;
                this.featureEnabled = featureEnabled;
            }

            public float m_141951_(@NotNull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int id) {
                if (!Client.this.enabled || !this.featureEnabled.getAsBoolean()) {
                    return 0.0f;
                }
                CompoundTag tag = stack.m_41783_();
                if (tag != null && tag.m_128425_("BucketVariantTag", 3)) {
                    int variant = tag.m_128451_("BucketVariantTag");
                    return this.extractor.applyAsInt(variant) + 1;
                }
                return 0.0f;
            }
        }
    }
}

